/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.sequence;

import junit.framework.Assert;
import org.junit.Test;
import step.core.dynamicbeans.DynamicValue;
import step.datapool.DataPoolConfiguration;
import step.datapool.DataPoolFactory;
import step.datapool.DataPoolRow;
import step.datapool.DataSet;
import step.datapool.sequence.IntSequenceDataPool;

public class IntSequenceDataPoolTest {
    @Test
    public void testCSVReaderDataPool() {
        int nbIncrementsWanted = 3;
        int maxIntWanted = 10;
        IntSequenceDataPool poolConf = new IntSequenceDataPool();
        poolConf.setStart(new DynamicValue((Object)1));
        poolConf.setEnd(new DynamicValue((Object)maxIntWanted));
        poolConf.setInc(new DynamicValue((Object)1));
        DataSet pool = DataPoolFactory.getDataPool((String)"sequence", (DataPoolConfiguration)poolConf, null);
        pool.init();
        Integer value = this.incrementNtimes(pool, nbIncrementsWanted);
        pool.close();
        Assert.assertEquals((int)nbIncrementsWanted, (int)value);
    }

    @Test
    public void testCSVReaderDataPoolReset() {
        int nbIncrementsWanted = 12;
        int maxIntWanted = 10;
        IntSequenceDataPool poolConf = new IntSequenceDataPool();
        poolConf.setStart(new DynamicValue((Object)1));
        poolConf.setEnd(new DynamicValue((Object)maxIntWanted));
        poolConf.setInc(new DynamicValue((Object)1));
        DataSet pool = DataPoolFactory.getDataPool((String)"sequence", (DataPoolConfiguration)poolConf, null);
        pool.init();
        Integer value = this.incrementNtimes(pool, nbIncrementsWanted);
        pool.close();
        Assert.assertEquals((int)(nbIncrementsWanted - maxIntWanted), (int)value);
    }

    private Integer incrementNtimes(DataSet<?> pool, int n) {
        int result = 0;
        for (int i = 0; i < n; ++i) {
            result = this.increment(pool);
        }
        return result;
    }

    private Integer increment(DataSet<?> pool) {
        DataPoolRow nextRow = pool.next();
        if (nextRow == null) {
            pool.reset();
            nextRow = pool.next();
        }
        return (Integer)nextRow.getValue();
    }
}

