/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import java.io.File;
import junit.framework.Assert;
import org.junit.Test;
import step.commons.helpers.FileHelper;
import step.core.dynamicbeans.DynamicValue;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.datapool.DataPoolConfiguration;
import step.datapool.DataPoolFactory;
import step.datapool.DataSet;
import step.datapool.file.DirectoryDataPool;

public class DirectoryDataPoolTest {
    @Test
    public void testDirectoryDataPoolTestToString() {
        DataSet<?> pool = this.getDataPool("folder", "folder");
        Assert.assertTrue((boolean)pool.next().getValue().toString().contains("File.txt"));
        pool.close();
    }

    protected DataSet<?> getDataPool(String file, String type) {
        DirectoryDataPool conf = this.getDataSourceConf(file);
        DataSet pool = DataPoolFactory.getDataPool((String)type, (DataPoolConfiguration)conf, (ExecutionContext)ContextBuilder.createLocalExecutionContext());
        pool.init();
        return pool;
    }

    private DirectoryDataPool getDataSourceConf(String filename) {
        File file = FileHelper.getClassLoaderResource(this.getClass(), (String)filename);
        DirectoryDataPool conf = new DirectoryDataPool();
        conf.setFolder(new DynamicValue((Object)file.getAbsolutePath()));
        return conf;
    }
}

