/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.UUID;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Assert;
import org.junit.Test;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCalcMode;
import step.commons.helpers.FileHelper;
import step.datapool.excel.WorkbookFile;

public class WorkbookFileTest {
    private File getResourceFile(String filename) {
        return FileHelper.getClassLoaderResource(this.getClass(), (String)filename);
    }

    @Test
    public void testRead() {
        WorkbookFile file = new WorkbookFile(this.getResourceFile("Excel1.xlsx"), null, false);
        Sheet s = file.getWorkbook().getSheetAt(0);
        Cell c = s.getRow(0).getCell(0);
        String value = c.getStringCellValue();
        file.close();
        Assert.assertEquals((Object)"Values", (Object)value);
    }

    @Test
    public void testWrite() throws IOException {
        String value = UUID.randomUUID().toString();
        File file = this.getResourceFile("WriteTest2.xlsx");
        if (file.exists()) {
            file.delete();
        }
        WorkbookFile workbook = new WorkbookFile(file, null, true);
        workbook.getWorkbook().createSheet("test").createRow(0).createCell(0).setCellValue(value);
        workbook.save();
        workbook.close();
        workbook = new WorkbookFile(file, null, false);
        Assert.assertEquals((Object)value, (Object)workbook.getWorkbook().getSheetAt(0).getRow(0).getCell(0).getStringCellValue());
        this.AssertForceFormulationRecalculationIsEnabled(workbook);
        workbook.close();
    }

    @Test
    public void testWriteForUpdate() throws IOException {
        String value = UUID.randomUUID().toString();
        File file = this.getResourceFile("WriteTest2.xlsx");
        if (file.exists()) {
            file.delete();
        }
        WorkbookFile workbook = new WorkbookFile(file, null, true, true);
        String sheet = "test";
        workbook.getWorkbook().createSheet(sheet).createRow(0).createCell(0).setCellValue(value);
        workbook.save();
        workbook.close();
        workbook = new WorkbookFile(file, null, false);
        Assert.assertEquals((Object)value, (Object)workbook.getWorkbook().getSheet(sheet).getRow(0).getCell(0).getStringCellValue());
        this.AssertForceFormulationRecalculationIsEnabled(workbook);
        workbook.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteForUpdateFileAlreadyOpened() throws IOException {
        File file = this.getResourceFile("WriteTest2.xlsx");
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        }
        Exception ex = null;
        RandomAccessFile access = null;
        FileLock lock = null;
        try {
            access = new RandomAccessFile(file, "rw");
            lock = access.getChannel().lock();
            WorkbookFile wb = new WorkbookFile(file, null, true, true);
            Throwable throwable = null;
            if (wb != null) {
                if (throwable != null) {
                    try {
                        wb.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    wb.close();
                }
            }
        }
        catch (Exception e) {
            ex = e;
            e.printStackTrace();
        }
        finally {
            try {
                lock.release();
            }
            catch (IOException iOException) {}
            access.close();
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)ex.getMessage().contains("is not writable"));
    }

    private void AssertForceFormulationRecalculationIsEnabled(WorkbookFile workbook) {
        CTCalcPr calc = ((XSSFWorkbook)workbook.getWorkbook()).getCTWorkbook().getCalcPr();
        Assert.assertNotNull((Object)calc);
        Assert.assertTrue((calc.getCalcMode() == STCalcMode.AUTO ? 1 : 0) != 0);
    }

    @Test
    public void testSizeLimit() {
        Exception ex = null;
        try {
            WorkbookFile workbook = new WorkbookFile(this.getResourceFile("Excel1.xlsx"), Integer.valueOf(1), false);
            workbook.close();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((ex != null && "The size of the workbook 'Excel1.xlsx' exceeds the max size 1bytes.".equals(ex.getMessage()) ? 1 : 0) != 0);
    }
}

