/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.ThreadGroup;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.Artefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.ContainsDynamicValues;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.runner.DefaultPlanRunner;
import step.planbuilder.PlanBuilder;

public class TestGroupHandler {
    @Test
    public void test() {
        ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setIterations(new DynamicValue((Object)10));
        threadGroup.setPacing(new DynamicValue((Object)10));
        threadGroup.setUsers(new DynamicValue((Object)5));
        AtomicInteger iterations = new AtomicInteger(0);
        TestArtefact c = new TestArtefact(iterations);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)threadGroup).add((AbstractArtefact)c).endBlock().build();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        long t1 = System.currentTimeMillis();
        ReportNode result = runner.run(plan);
        long t2 = System.currentTimeMillis();
        plan.getArtefacts();
        Assert.assertEquals((int)50, (int)iterations.get());
        Assert.assertEquals((int)0, (int)((Integer)c.localCount.get()));
        Assert.assertEquals((int)0, (int)((Integer)c.member.localCount.get()));
        Assert.assertTrue((t2 - t1 > 100L ? 1 : 0) != 0);
    }

    public static class TestArtefactHandler
    extends ArtefactHandler<TestArtefact, ReportNode> {
        protected void createReportSkeleton_(ReportNode parentNode, TestArtefact testArtefact) {
        }

        protected void execute_(ReportNode node, TestArtefact testArtefact) {
            node.setStatus(ReportNodeStatus.PASSED);
            testArtefact.iterations.incrementAndGet();
            testArtefact.localCount.setValue((Object)((Integer)testArtefact.localCount.get() + 1));
            testArtefact.member.localCount.setValue((Object)((Integer)testArtefact.member.localCount.get() + 1));
        }

        public ReportNode createReportNode_(ReportNode parentNode, TestArtefact testArtefact) {
            return new ReportNode();
        }
    }

    public static class TestArtefactMember {
        DynamicValue<Integer> localCount = new DynamicValue((Object)0);
    }

    @Artefact(handler=TestArtefactHandler.class)
    public static class TestArtefact
    extends AbstractArtefact {
        AtomicInteger iterations;
        DynamicValue<Integer> localCount = new DynamicValue((Object)0);
        TestArtefactMember member = new TestArtefactMember();

        public TestArtefact() {
        }

        public TestArtefact(AtomicInteger iterations) {
            this.iterations = iterations;
        }

        public AtomicInteger getIterations() {
            return this.iterations;
        }

        public void setIterations(AtomicInteger iterations) {
            this.iterations = iterations;
        }

        public DynamicValue<Integer> getLocalCount() {
            return this.localCount;
        }

        public void setLocalCount(DynamicValue<Integer> localCount) {
            this.localCount = localCount;
        }

        @ContainsDynamicValues
        public TestArtefactMember getMember() {
            return this.member;
        }

        public void setMember(TestArtefactMember member) {
            this.member = member;
        }
    }
}

