/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.artefacts.ForBlock;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.artefacts.reports.ForBlockReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.execution.ExecutionContext;
import step.datapool.DataPoolConfiguration;
import step.datapool.sequence.IntSequenceDataPool;

public class ForHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void testSuccess() {
        this.setupContext();
        this.context.getVariablesManager().putVariable(this.context.getReport(), "var", (Object)"val1");
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)3));
        conf.setInc(new DynamicValue((Object)2));
        f.setDataSource((DataPoolConfiguration)conf);
        f.setItem(new DynamicValue((Object)"item"));
        final AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
                Assert.assertEquals((int)i.get(), (int)ForHandlerTest.this.context.getVariablesManager().getVariableAsInteger("item"));
                i.addAndGet(2);
            }
        }), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        Assert.assertEquals((int)2, (int)child.getCount());
        Assert.assertEquals((int)0, (int)child.getErrorCount());
        Assert.assertEquals((int)this.getChildren((ReportNode)child).size(), (int)2);
        for (ReportNode node : this.getChildren((ReportNode)child)) {
            Assert.assertEquals((Object)node.getStatus(), (Object)ReportNodeStatus.PASSED);
            Assert.assertEquals((int)this.getChildren(node).size(), (int)1);
            Assert.assertEquals((Object)check1.getId(), (Object)this.getChildren(node).get(0).getArtefactID());
        }
    }

    @Test
    public void testBreak() {
        this.setupContext();
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)10));
        f.setDataSource((DataPoolConfiguration)conf);
        final AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(new Runnable(){

            @Override
            public void run() {
                if (i.get() == 2) {
                    ForHandlerTest.this.context.getVariablesManager().updateVariable("break", (Object)"true");
                }
                i.addAndGet(1);
            }
        }), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        Assert.assertEquals((int)2, (int)child.getCount());
        Assert.assertEquals((int)0, (int)child.getErrorCount());
    }

    @Test
    public void testMaxFailedCount() {
        this.setupContext();
        ForBlock f = this.add(new ForBlock());
        IntSequenceDataPool conf = new IntSequenceDataPool();
        conf.setEnd(new DynamicValue((Object)10));
        f.setDataSource((DataPoolConfiguration)conf);
        f.setMaxFailedLoops(new DynamicValue((Object)2));
        AtomicInteger i = new AtomicInteger(1);
        CheckArtefact check1 = this.addAsChildOf(new CheckArtefact(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getCurrentReportNode().setStatus(ReportNodeStatus.FAILED);
            }
        }), (AbstractArtefact)f);
        this.execute((AbstractArtefact)f);
        ForBlockReportNode child = (ForBlockReportNode)this.getFirstReportNode();
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.FAILED);
        Assert.assertEquals((int)2, (int)child.getCount());
        Assert.assertEquals((int)2, (int)child.getErrorCount());
    }
}

