/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import step.artefacts.CallPlan;
import step.artefacts.CheckArtefact;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.plans.Plan;
import step.planbuilder.PlanBuilder;

public class CallPlanHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void test() {
        this.context = ContextBuilder.createLocalExecutionContext();
        AtomicBoolean executed = new AtomicBoolean();
        CheckArtefact check = new CheckArtefact(() -> {
            ExecutionContext.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
            executed.set(true);
        });
        Plan calledPlan = PlanBuilder.create().add((AbstractArtefact)check).build();
        this.context.getGlobalContext().getArtefactAccessor().save(new ArrayList(calledPlan.getArtefacts()));
        CallPlan callPlan = new CallPlan();
        callPlan.setArtefactId(calledPlan.getRoot().getId().toString());
        Plan plan = PlanBuilder.create().add((AbstractArtefact)callPlan).build();
        this.context.getGlobalContext().getArtefactAccessor().save(new ArrayList(plan.getArtefacts()));
        ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)plan.getRoot(), (ReportNode)this.context.getReport());
        ArtefactHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)plan.getRoot(), (ReportNode)this.context.getReport());
        Assert.assertTrue((boolean)executed.get());
        Assert.assertTrue((boolean)this.getChildren(this.context.getReport()).get(0).getStatus().equals((Object)ReportNodeStatus.PASSED));
    }
}

