/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import step.artefacts.CheckArtefact;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionTestHelper;

public class AbstractArtefactHandlerTest {
    protected ExecutionContext context;

    protected void setupContext() {
        this.context = ExecutionTestHelper.setupContext();
    }

    protected <T extends AbstractArtefact> T add(T artefact) {
        this.getArtefactAccessor().save(artefact);
        return artefact;
    }

    private ArtefactAccessor getArtefactAccessor() {
        return this.context.getGlobalContext().getArtefactAccessor();
    }

    protected <T extends AbstractArtefact> T addAsChildOf(T artefact, AbstractArtefact parent) {
        this.getArtefactAccessor().get(parent.getId()).addChild(artefact.getId());
        return this.add(artefact);
    }

    protected void createSkeleton(AbstractArtefact artefact) {
        ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)artefact, (ReportNode)this.context.getReport());
    }

    protected void execute(AbstractArtefact artefact) {
        ArtefactHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)artefact, (ReportNode)this.context.getReport());
    }

    protected ReportNode getFirstReportNode() {
        return (ReportNode)this.getReportNodeAccessor().getChildren(this.context.getReportNodeTree().getRoot().getId()).next();
    }

    protected List<ReportNode> getChildren(ReportNode node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getReportNodeAccessor().getChildren(node.getId()), 16), false).collect(Collectors.toList());
    }

    private ReportNodeAccessor getReportNodeAccessor() {
        return this.context.getGlobalContext().getReportAccessor();
    }

    protected CheckArtefact newTestArtefact(final ReportNodeStatus status) {
        return new CheckArtefact(new Runnable(){

            @Override
            public void run() {
                ExecutionContext.getCurrentReportNode().setStatus(status);
            }
        });
    }
}

