/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import step.core.variables.SimpleStringMap;
import step.datapool.DataSet;
import step.datapool.jdbc.SQLTableDataPoolConfiguration;

public class SQLTableDataPool
extends DataSet<SQLTableDataPoolConfiguration> {
    private Connection conn1;
    private Statement smt;
    private ResultSet rs = null;
    private String jdbc_url;
    private String db_user;
    private String db_pwd;
    private String driver_class;
    private String query;
    private String table;
    private String writePKey;
    private ArrayList<String> cols;

    public SQLTableDataPool(SQLTableDataPoolConfiguration configuration) {
        super((Object)configuration);
        this.jdbc_url = (String)configuration.getConnectionString().get();
        this.db_user = (String)configuration.getUser().get();
        this.db_pwd = (String)configuration.getPassword().get();
        this.driver_class = (String)configuration.getDriverClass().get();
        this.writePKey = (String)configuration.getWritePKey().get();
        this.query = (String)configuration.getQuery().get();
        this.table = SQLTableDataPool.parseQueryForTable(this.query);
        try {
            Class.forName(this.driver_class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load jdbc driver for class:" + this.driver_class);
        }
    }

    private static String parseQueryForTable(String query) {
        Pattern p = Pattern.compile("(^|\\s)select.+?from (.+?)(\\s|$)");
        Matcher m = p.matcher(query.toLowerCase());
        if (!m.find() || m.groupCount() < 3) {
            throw new RuntimeException("Could not parse query :" + query);
        }
        return m.group(2);
    }

    public void connect() {
        try {
            this.conn1 = DriverManager.getConnection(this.jdbc_url, this.db_user, this.db_pwd);
            this.conn1.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not connect to the following datapool db :" + this.jdbc_url + " with user '" + this.db_user + "'");
        }
    }

    public void reset() {
        this.executeQuery();
    }

    public void executeQuery() {
        try {
            this.smt = this.conn1.createStatement();
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.rs = this.smt.executeQuery(this.query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not execute query :" + this.query);
        }
        try {
            ResultSetMetaData meta = null;
            meta = this.rs.getMetaData();
            int colCount = meta.getColumnCount();
            this.cols = new ArrayList();
            for (int index = 1; index <= colCount; ++index) {
                this.cols.add(meta.getColumnName(index));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not retrieve result set data from query :" + this.query);
        }
    }

    public Object next_() {
        ConcurrentHashMap<String, Object> row = null;
        try {
            if (this.rs.next()) {
                row = new ConcurrentHashMap<String, Object>();
                Object pkValue = null;
                for (String colName : this.cols) {
                    Object val = this.rs.getObject(colName);
                    row.put(colName, val);
                    if (!colName.trim().toLowerCase().equals(this.writePKey.trim().toLowerCase())) continue;
                    pkValue = val;
                }
                return new SQLRowWrapper(this.rs.getRow(), row, pkValue);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new RuntimeException("Could not retrieve the next row." + this.rs.getRow());
            }
            catch (SQLException e1) {
                throw new RuntimeException("Could not retrieve the next row.");
            }
        }
    }

    public void addRow(Object row) {
        throw new RuntimeException("Not implemented");
    }

    public void close() {
        try {
            this.conn1.commit();
            if (this.rs != null && !this.rs.isClosed()) {
                this.rs.close();
            }
            this.conn1.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void init() {
        this.connect();
        this.executeQuery();
    }

    public class SQLRowWrapper
    extends SimpleStringMap {
        private final Object pkValue;
        private ConcurrentHashMap<String, Object> rowData;

        public SQLRowWrapper(int rowNum, ConcurrentHashMap<String, Object> row, Object pkValue) throws Exception {
            this.pkValue = pkValue;
            if (rowNum < 1) {
                throw new Exception("Invalid row number:" + rowNum);
            }
            this.rowData = row;
        }

        public String put(String key, String value) {
            String sql = null;
            Statement update = null;
            if (this.pkValue != null) {
                sql = this.pkValue instanceof String ? "UPDATE " + SQLTableDataPool.this.table + " SET " + key + " = '" + value + "' WHERE " + SQLTableDataPool.this.writePKey + " = '" + this.pkValue + "'" : "UPDATE " + SQLTableDataPool.this.table + " SET " + key + " = '" + value + "' WHERE " + SQLTableDataPool.this.writePKey + " = " + this.pkValue;
            } else {
                throw new RuntimeException("The value of the primary key :" + SQLTableDataPool.this.writePKey + " is null. Unable to update key=" + key + " and value=" + value);
            }
            try {
                update = SQLTableDataPool.this.conn1.createStatement();
                update.setQueryTimeout(2);
                update.executeUpdate(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not execute update with pk :" + SQLTableDataPool.this.writePKey + " = " + this.pkValue + ", with key=" + key + " and value=" + value);
            }
            finally {
                try {
                    if (!update.isClosed()) {
                        update.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                SQLTableDataPool.this.conn1.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException("Commit failed");
            }
            this.rowData.put(key, value);
            return value;
        }

        public String get(String key) {
            return (String)this.rowData.get(key);
        }

        public String toString() {
            return this.rowData.toString();
        }

        public int size() {
            return this.rowData.size();
        }

        public boolean isEmpty() {
            return this.rowData.isEmpty();
        }

        public Set<String> keySet() {
            return this.rowData.keySet();
        }
    }
}

