/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.datapool.excel.WorkbookFile;

public class WorkbookSet
implements AutoCloseable {
    private LinkedWorkbookFileResolver resolver;
    private List<WorkbookFile> workbooks = new ArrayList<WorkbookFile>();
    private File mainWorkbookFile;
    private WorkbookFile mainWorkbook;
    private FormulaEvaluator mainFormulaEvaluator;
    private static final Logger logger = LoggerFactory.getLogger(WorkbookSet.class);

    public WorkbookSet(File mainWorkbookFile, Integer maxWorkbookSize, LinkedWorkbookFileResolver resolver, boolean createIfNotExists, boolean forUpdate) {
        this.resolver = resolver;
        this.mainWorkbookFile = mainWorkbookFile;
        this.mainWorkbook = this.openWorkbook(mainWorkbookFile, maxWorkbookSize, createIfNotExists, forUpdate);
        this.mainFormulaEvaluator = this.mainWorkbook.getWorkbook().getCreationHelper().createFormulaEvaluator();
        this.openReferencedWorkbooks(maxWorkbookSize, this.mainWorkbook.getWorkbook(), this.mainFormulaEvaluator);
    }

    public WorkbookSet(File mainWorkbookFile, Integer maxWorkbookSize, boolean createIfNotExists, boolean forUpdate) {
        this(mainWorkbookFile, maxWorkbookSize, new LinkedWorkbookFileResolver(){

            @Override
            public File resolve(String linkedFilename) {
                if (linkedFilename.startsWith("file:///")) {
                    return new File(linkedFilename.substring(8));
                }
                return null;
            }
        }, createIfNotExists, forUpdate);
    }

    public void save() throws IOException {
        this.mainWorkbook.save();
    }

    @Override
    public void close() {
        for (WorkbookFile workbook : this.workbooks) {
            workbook.close();
        }
        this.workbooks = null;
    }

    public File getMainWorkbookFile() {
        return this.mainWorkbookFile;
    }

    public Workbook getMainWorkbook() {
        return this.mainWorkbook.getWorkbook();
    }

    public FormulaEvaluator getMainFormulaEvaluator() {
        return this.mainFormulaEvaluator;
    }

    private void openReferencedWorkbooks(Integer maxWorkbookSize, Workbook workbook, FormulaEvaluator evaluator) {
        HashMap<String, FormulaEvaluator> workbooks = new HashMap<String, FormulaEvaluator>();
        if (workbook instanceof XSSFWorkbook && ((XSSFWorkbook)workbook).getExternalLinksTable() != null) {
            for (ExternalLinksTable sheet : ((XSSFWorkbook)workbook).getExternalLinksTable()) {
                String file = sheet.getLinkedFileName();
                File f = this.resolver.resolve(file);
                if (f != null) {
                    try {
                        WorkbookFile book = this.openWorkbook(f, maxWorkbookSize, false, false);
                        workbooks.put(file, book.getWorkbook().getCreationHelper().createFormulaEvaluator());
                    }
                    catch (Exception e) {
                        logger.error("An error occured while opening referenced workbook '" + file + "'. Main workbook: '" + this.mainWorkbookFile + "'");
                    }
                    continue;
                }
                logger.warn("Unable to resolve external workbook '" + file + "'. Main workbook: '" + this.mainWorkbookFile + "'");
            }
        }
        workbooks.put("this", evaluator);
        evaluator.setupReferencedWorkbooks(workbooks);
    }

    private WorkbookFile openWorkbook(File mainWorkbook, Integer maxWorkbookSize, boolean createIfNotExists, boolean forUpdate) {
        WorkbookFile openedOprkbook = new WorkbookFile();
        openedOprkbook.open(mainWorkbook, maxWorkbookSize, createIfNotExists, forUpdate);
        this.workbooks.add(openedOprkbook);
        return openedOprkbook;
    }

    public static interface LinkedWorkbookFileResolver {
        public File resolve(String var1);
    }
}

