/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.awt.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleSyntax {
    public static XSSFCellStyle composeStyle(String strStyle, Workbook _wb) {
        if (_wb instanceof XSSFWorkbook) {
            String[] arr;
            XSSFWorkbook wb = (XSSFWorkbook)_wb;
            if (strStyle == null || strStyle.isEmpty()) {
                return null;
            }
            XSSFCellStyle style = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            strStyle = StyleSyntax.replaceColors(strStyle);
            for (String str : arr = strStyle.split(",")) {
                if (str.matches("( *bold *| *italic *| *underline *| *strikeout *)*")) {
                    if (str.contains("bold")) {
                        font.setBoldweight((short)700);
                    }
                    if (str.contains("italic")) {
                        font.setItalic(true);
                    }
                    if (str.contains("underline")) {
                        font.setUnderline((byte)1);
                    }
                    if (!str.contains("strikeout")) continue;
                    font.setStrikeout(true);
                    continue;
                }
                if (str.contains("/") && !str.contains(":")) continue;
                if (str.contains(":")) {
                    String[] fgBg = str.contains("/") ? str.split("/") : new String[]{str};
                    for (int i = 0; i < fgBg.length; ++i) {
                        XSSFColor xssfColor;
                        fgBg[i] = fgBg[i].trim();
                        if (fgBg[i].isEmpty()) continue;
                        String[] clr = fgBg[i].split(":");
                        if (clr.length != 3) {
                            return null;
                        }
                        int red = Integer.parseInt(clr[0].trim());
                        int green = Integer.parseInt(clr[1].trim());
                        int blue = Integer.parseInt(clr[2].trim());
                        if (i == 0) {
                            if (red == 0 && green == 0 && blue == 0) {
                                red = 255;
                                green = 255;
                                blue = 255;
                            } else if (red == 255 && green == 255 && blue == 255) {
                                red = 0;
                                green = 0;
                                blue = 0;
                            }
                            xssfColor = new XSSFColor(new Color(red, green, blue));
                            font.setColor(xssfColor);
                            continue;
                        }
                        xssfColor = new XSSFColor(new Color(red, green, blue));
                        style.setFillForegroundColor(xssfColor);
                        style.setFillBackgroundColor(xssfColor);
                        style.setFillPattern((short)1);
                    }
                    continue;
                }
                if (str.matches(" *[1-9][0-9]* *")) {
                    short fontHeightInPoints = Short.parseShort(str.trim());
                    font.setFontHeightInPoints(fontHeightInPoints);
                    continue;
                }
                if (str.isEmpty()) continue;
                font.setFontName(str);
            }
            style.setFont((Font)font);
            return style;
        }
        return null;
    }

    private static String replaceColors(String strStyle) {
        strStyle = strStyle.replaceAll("black", "0:0:0");
        strStyle = strStyle.replaceAll("white", "255:255:255");
        strStyle = strStyle.replace("red", "255:0:0");
        strStyle = strStyle.replace("green", "0:255:0");
        strStyle = strStyle.replace("blue", "0:0:255");
        strStyle = strStyle.replace("yellow", "255:255:0");
        strStyle = strStyle.replace("violet", "255:0:255");
        strStyle = strStyle.replace("cyan", "0:255:255");
        strStyle = strStyle.replace("grey", "128:128:128");
        strStyle = strStyle.replace("gray", "128:128:128");
        return strStyle;
    }
}

