/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.spi.JsonProvider;
import step.artefacts.CallPlan;
import step.artefacts.handlers.SelectorHelper;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.execution.ExecutionContext;

public class CallPlanHandler
extends ArtefactHandler<CallPlan, ReportNode> {
    private static JsonProvider jprov = JsonProvider.provider();
    protected DynamicJsonObjectResolver dynamicJsonObjectResolver;

    public void init(ExecutionContext context) {
        super.init(context);
        this.dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(context.getGlobalContext().getExpressionHandler()));
    }

    protected void createReportSkeleton_(ReportNode parentNode, CallPlan testArtefact) {
        this.beforeDelegation(parentNode, testArtefact);
        AbstractArtefact a = this.selectArtefact(testArtefact);
        this.delegateCreateReportSkeleton(a, parentNode);
    }

    private void beforeDelegation(ReportNode parentNode, CallPlan testArtefact) {
        this.context.getVariablesManager().putVariable(parentNode, "#placeholder", (Object)testArtefact);
        String inputJson = testArtefact.getInput().get() != null ? (String)testArtefact.getInput().get() : "{}";
        JsonObject input = jprov.createReader((Reader)new StringReader(inputJson)).readObject();
        JsonObject resolvedInput = this.dynamicJsonObjectResolver.evaluate(input, this.getBindings());
        this.context.getVariablesManager().putVariable(parentNode, "input", (Object)resolvedInput);
    }

    protected void execute_(ReportNode node, CallPlan testArtefact) {
        this.beforeDelegation(node, testArtefact);
        AbstractArtefact a = this.selectArtefact(testArtefact);
        ReportNode resultNode = CallPlanHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)a, (ReportNode)node);
        node.setStatus(resultNode.getStatus());
    }

    protected AbstractArtefact selectArtefact(CallPlan testArtefact) {
        AbstractArtefact a;
        ArtefactAccessor artefactAccessor = this.context.getGlobalContext().getArtefactAccessor();
        if (testArtefact.getArtefactId() != null) {
            a = this.context.getGlobalContext().getArtefactAccessor().get(testArtefact.getArtefactId());
        } else {
            DynamicJsonObjectResolver dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(this.context.getGlobalContext().getExpressionHandler()));
            SelectorHelper selectorHelper = new SelectorHelper(dynamicJsonObjectResolver);
            Map<String, String> selectionAttributes = selectorHelper.buildSelectionAttributesMap((String)testArtefact.getSelectionAttributes().get(), this.getBindings());
            a = artefactAccessor.findRootArtefactByAttributes(selectionAttributes);
            if (a == null) {
                throw new RuntimeException("Unable to find plan with attributes: " + selectionAttributes.toString());
            }
        }
        return a;
    }

    public ReportNode createReportNode_(ReportNode parentNode, CallPlan testArtefact) {
        return new ReportNode();
    }
}

