/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.json.JsonObject;
import junit.framework.Assert;
import org.junit.Test;
import step.core.dynamicbeans.DynamicValue;
import step.core.variables.SimpleStringMap;
import step.datapool.DataPoolRow;
import step.datapool.Utils;
import step.datapool.excel.ExcelDataPool;
import step.datapool.excel.ExcelDataPoolImpl;
import step.datapool.excel.ExcelFunctionsTest;

public class ExcelDataPoolTest {
    @Test
    public void testDefaultSheet() {
        ExcelDataPool conf = this.getDataSourceConf(false, "ExcelDataPool.xlsx", null);
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(conf);
        pool.init();
        Assert.assertEquals((String)"DefaultValue", (String)((SimpleStringMap)pool.next().getValue()).get("A"));
        pool.close();
    }

    @Test
    public void testToString() {
        ExcelDataPool conf = this.getDataSourceConf(true, "ExcelDataPool.xlsx", "Parallel");
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(conf);
        pool.init();
        Assert.assertTrue((boolean)((SimpleStringMap)pool.next().getValue()).toString().startsWith("Keys=Key1 Values=Value1 Result="));
        pool.close();
    }

    @Test
    public void testReset() {
        ExcelDataPool conf = this.getDataSourceConf(false, "ExcelDataPool.xlsx", null);
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(conf);
        pool.init();
        Assert.assertEquals((String)"DefaultValue", (String)((SimpleStringMap)pool.next().getValue()).get("A"));
        pool.reset();
        Assert.assertEquals((String)"DefaultValue", (String)((SimpleStringMap)pool.next().getValue()).get("A"));
        Assert.assertEquals(null, (Object)pool.next());
        pool.close();
    }

    @Test
    public void testParallel() throws InterruptedException {
        final int nIt = 1000;
        final int nThreads = 10;
        ExecutorService service = Executors.newFixedThreadPool(nThreads);
        final ConcurrentHashMap map = new ConcurrentHashMap();
        ExcelDataPool conf = this.getDataSourceConf(true, "ExcelDataPool.xlsx", "Parallel");
        final ExcelDataPoolImpl pool = new ExcelDataPoolImpl(conf);
        pool.init();
        final ArrayList exceptions = new ArrayList();
        final String uid = UUID.randomUUID().toString();
        for (int j = 0; j < nThreads; ++j) {
            service.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (int i = 0; i < nIt / nThreads; ++i) {
                        try {
                            SimpleStringMap row = (SimpleStringMap)pool.next().getValue();
                            row.put("Result", uid + "_" + row.get("Values"));
                            map.put(row.get("Keys"), row.get("Values"));
                            continue;
                        }
                        catch (Exception e) {
                            Exception exception = e;
                            synchronized (exception) {
                                exceptions.add(e);
                            }
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        service.shutdown();
        service.awaitTermination(1L, TimeUnit.MINUTES);
        for (int i = 1; i <= nIt; ++i) {
            Assert.assertEquals((String)("Value" + i), (String)((String)map.get("Key" + i)));
        }
        pool.save();
        pool.close();
        Assert.assertEquals((int)0, (int)exceptions.size());
        ExcelDataPoolImpl pool2 = new ExcelDataPoolImpl(conf);
        pool2.init();
        for (int i = 1; i <= nIt; ++i) {
            SimpleStringMap row = (SimpleStringMap)pool2.next().getValue();
            Assert.assertEquals((String)(uid + "_Value" + i), (String)row.get("Result"));
        }
        pool2.close();
    }

    private ExcelDataPool getDataSourceConf(boolean headers, String file, String worksheet) {
        ExcelDataPool conf = new ExcelDataPool();
        conf.setFile(new DynamicValue((Object)ExcelFunctionsTest.getResourceFile(file).getAbsolutePath()));
        conf.setHeaders(new DynamicValue((Object)headers));
        conf.setWorksheet(new DynamicValue((Object)worksheet));
        return conf;
    }

    @Test
    public void testWithoutHeaders() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(false, "ExcelDataPool.xlsx", "WithoutHeaders"));
        pool.init();
        for (int i = 1; i <= 10; ++i) {
            Assert.assertEquals((String)("Value" + i), (String)((SimpleStringMap)pool.next().getValue()).get("B"));
        }
        Assert.assertNull((Object)pool.next());
        pool.close();
    }

    @Test
    public void testCrossSheet() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(false, "ExcelDataPool.xlsx", "WithoutHeaders"));
        pool.init();
        for (int i = 1; i <= 10; ++i) {
            Assert.assertEquals((String)("Value" + i), (String)((SimpleStringMap)pool.next().getValue()).get("WithoutHeaders2::B"));
        }
        Assert.assertNull((Object)pool.next());
        pool.close();
    }

    @Test
    public void testWithHeaders() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPool.xlsx", "WithHeaders"));
        pool.init();
        for (int i = 1; i <= 10; ++i) {
            SimpleStringMap row = (SimpleStringMap)pool.next().getValue();
            Assert.assertEquals((String)("Value" + i), (String)row.get("Values"));
            Assert.assertEquals((String)("Key" + i), (String)row.get("Keys"));
            JsonObject jsonRow = Utils.toJson((Map)row);
            Assert.assertEquals((String)("Key" + i), (String)jsonRow.getString("Keys"));
            Assert.assertEquals((String)("Value" + i), (String)jsonRow.getString("Values"));
        }
        Assert.assertNull((Object)pool.next());
        pool.close();
    }

    @Test
    public void testWrite() {
        SimpleStringMap row;
        int i;
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPool.xlsx", "Write"));
        pool.init();
        String value = UUID.randomUUID().toString();
        for (i = 1; i <= 10; ++i) {
            row = (SimpleStringMap)pool.next().getValue();
            Assert.assertEquals((String)("input" + i), (String)row.get("Input"));
            row.put("Output", value + i);
        }
        pool.save();
        pool.close();
        pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPool.xlsx", "Write"));
        pool.init();
        for (i = 1; i <= 10; ++i) {
            row = (SimpleStringMap)pool.next().getValue();
            Assert.assertEquals((String)("input" + i), (String)row.get("Input"));
            Assert.assertEquals((String)(value + i), (String)row.get("Output"));
        }
        Assert.assertNull((Object)pool.next());
        pool.close();
    }

    @Test
    public void testValueChanged() {
        DataPoolRow r;
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPoolValueChanged.xlsx", "DefaultSheet"));
        pool.init();
        while ((r = pool.next()) != null) {
            SimpleStringMap row = (SimpleStringMap)r.getValue();
            Assert.assertEquals((String)"ELSE", (String)row.get("Value"));
            row.put("Actual", "passed");
            Assert.assertEquals((String)"SKIP", (String)row.get("Value"));
        }
        pool.close();
    }

    @Test
    public void testNoSave() {
        SimpleStringMap row;
        int i;
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPoolImmutable.xlsx", "Write"));
        pool.init();
        String value = UUID.randomUUID().toString();
        for (i = 1; i <= 10; ++i) {
            row = (SimpleStringMap)pool.next().getValue();
            Assert.assertEquals((String)("input" + i), (String)row.get("Input"));
            row.put("Output", value + i);
        }
        pool.close();
        pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPoolImmutable.xlsx", "Write"));
        pool.init();
        for (i = 1; i <= 10; ++i) {
            row = (SimpleStringMap)pool.next().getValue();
            Assert.assertEquals((String)("input" + i), (String)row.get("Input"));
        }
        pool.close();
    }

    @Test
    public void testSKIP() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(false, "ExcelDataPool.xlsx", "SKIP"));
        pool.init();
        int i = 0;
        while (pool.next() != null) {
            ++i;
        }
        Assert.assertEquals((int)7, (int)i);
        pool.close();
    }

    @Test
    public void testStop() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(false, "ExcelDataPool.xlsx", "Stop"));
        pool.init();
        int i = 0;
        while (pool.next() != null) {
            ++i;
        }
        Assert.assertEquals((int)3, (int)i);
        pool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRow() {
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPool.xlsx", "AddRow"));
        pool.init();
        String uid = UUID.randomUUID().toString();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Col1", uid);
        row.put("Col2", uid);
        row.put("Col" + uid, uid);
        pool.addRow(row);
        pool.save();
        pool.close();
        pool = new ExcelDataPoolImpl(this.getDataSourceConf(true, "ExcelDataPool.xlsx", "AddRow"));
        pool.init();
        try {
            DataPoolRow next;
            boolean containsNewRow = false;
            boolean containsNewColumn = false;
            while ((next = pool.next()) != null) {
                SimpleStringMap map = (SimpleStringMap)next.getValue();
                if (map.get("Col1").equals(uid)) {
                    containsNewRow = true;
                }
                if (!map.get("Col" + uid).equals(uid)) continue;
                containsNewColumn = true;
            }
            Assert.assertTrue((boolean)containsNewRow);
            Assert.assertTrue((boolean)containsNewColumn);
        }
        finally {
            pool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRowToNewExcel() {
        String uid = UUID.randomUUID().toString();
        ExcelDataPool conf = new ExcelDataPool();
        conf.setFile(new DynamicValue((Object)(ExcelFunctionsTest.getResourceFile(".").getAbsolutePath() + "/testNewExcel" + uid + ".xlsx")));
        conf.setHeaders(new DynamicValue((Object)true));
        conf.setWorksheet(new DynamicValue((Object)"Test"));
        conf.setForWrite(new DynamicValue((Object)true));
        ExcelDataPoolImpl pool = new ExcelDataPoolImpl(conf);
        pool.init();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Col1", uid);
        row.put("Col2", uid);
        row.put("Col" + uid, uid);
        pool.addRow(row);
        pool.save();
        pool.close();
        pool = new ExcelDataPoolImpl(conf);
        pool.init();
        try {
            DataPoolRow next;
            boolean containsNewRow = false;
            boolean containsNewColumn = false;
            while ((next = pool.next()) != null) {
                SimpleStringMap map = (SimpleStringMap)next.getValue();
                if (map.get("Col1").equals(uid)) {
                    containsNewRow = true;
                }
                if (!map.get("Col" + uid).equals(uid)) continue;
                containsNewColumn = true;
            }
            Assert.assertTrue((boolean)containsNewRow);
            Assert.assertTrue((boolean)containsNewColumn);
        }
        finally {
            pool.close();
        }
    }
}

