/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.artefacts.TestSet;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;

public class TestSetHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void testParallel() throws Exception {
        HashSet<Long> threadIdSet = new HashSet<Long>();
        this.execute(threadIdSet, "10", "DummyName{childID}");
        Assert.assertEquals((String)"Ensure that the TestSetHandler runs the child artefacts in parallel", (int)10, (int)threadIdSet.size());
    }

    @Test
    public void testSequential() throws Exception {
        HashSet<Long> threadIdSet = new HashSet<Long>();
        this.execute(threadIdSet, "1", "DummyName{childID}");
        Assert.assertEquals((String)"Ensure that the TestSetHandler runs the child artefacts sequentially", (int)1, (int)threadIdSet.size());
    }

    private void execute(final HashSet<Long> threadIdSet, String tecExecutionThreads, String childNamePattern) {
        this.setupContext();
        this.context.getVariablesManager().putVariable(this.context.getReport(), "tec.execution.threads", (Object)tecExecutionThreads);
        this.context.getVariablesManager().getVariable("var");
        TestSet set = new TestSet();
        this.add(set);
        int nChilds = 20;
        for (int j = 0; j < nChilds; ++j) {
            this.addAsChildOf(new CheckArtefact(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet hashSet = threadIdSet;
                    synchronized (hashSet) {
                        threadIdSet.add(Thread.currentThread().getId());
                    }
                    ExecutionContext.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED);
                }
            }), (AbstractArtefact)set);
        }
        this.createSkeleton((AbstractArtefact)set);
        this.execute((AbstractArtefact)set);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)child.getStatus(), (Object)ReportNodeStatus.PASSED);
        Assert.assertEquals((int)nChilds, (int)this.getChildren(child).size());
        for (ReportNode node : this.getChildren(child)) {
            Assert.assertEquals((Object)node.getStatus(), (Object)ReportNodeStatus.PASSED);
        }
    }
}

