/*
 * Decompiled with CFR 0.152.
 */
package step.artefacts.handlers;

import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.Sequence;
import step.artefacts.handlers.AbstractArtefactHandlerTest;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;

public class SequenceHandlerTest
extends AbstractArtefactHandlerTest {
    @Test
    public void test1ChildPassed() {
        for (ReportNodeStatus status : ReportNodeStatus.values()) {
            this.test1Child(status);
        }
    }

    private void test1Child(ReportNodeStatus status) {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        this.addAsChildOf(this.newTestArtefact(status), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)status, (Object)child.getStatus());
    }

    @Test
    public void test2ChildrenFailed() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.FAILED), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.FAILED, (Object)child.getStatus());
    }

    @Test
    public void test2ChildrenTechError() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.TECHNICAL_ERROR), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)child.getStatus());
    }

    @Test
    public void testDefaultContinueOnError() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.TECHNICAL_ERROR), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)child.getStatus());
        Assert.assertEquals((int)1, (int)this.getChildren(child).size());
    }

    @Test
    public void testDefaultContinueOnError_2() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.TECHNICAL_ERROR), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)child.getStatus());
        Assert.assertEquals((int)2, (int)this.getChildren(child).size());
    }

    @Test
    public void testContinueOnError() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        block.setContinueOnError(new DynamicValue((Object)true));
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.TECHNICAL_ERROR), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)child.getStatus());
        Assert.assertEquals((int)2, (int)this.getChildren(child).size());
    }

    @Test
    public void testContinueOnError_2() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        block.setContinueOnError(new DynamicValue((Object)true));
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.FAILED), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.FAILED, (Object)child.getStatus());
        Assert.assertEquals((int)2, (int)this.getChildren(child).size());
    }

    @Test
    public void testNotContinueOnError() {
        this.setupContext();
        Sequence block = this.add(new Sequence());
        block.setContinueOnError(new DynamicValue((Object)false));
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.FAILED), (AbstractArtefact)block);
        this.addAsChildOf(this.newTestArtefact(ReportNodeStatus.PASSED), (AbstractArtefact)block);
        this.execute((AbstractArtefact)block);
        ReportNode child = this.getFirstReportNode();
        Assert.assertEquals((Object)ReportNodeStatus.FAILED, (Object)child.getStatus());
        Assert.assertEquals((int)1, (int)this.getChildren(child).size());
    }
}

