/*
 * Decompiled with CFR 0.152.
 */
package step.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.artefacts.reports.ReportNodeVisitorEventHandler;
import step.core.artefacts.reports.ReportTreeAccessor;
import step.core.artefacts.reports.ReportTreeVisitor;
import step.reporting.ReportWriter;

public class JUnit4ReportWriter
implements ReportWriter {
    public void writeReport(ReportTreeAccessor reportTreeAccessor, String executionId, File outputFile) throws IOException {
        ReportTreeVisitor visitor = new ReportTreeVisitor(reportTreeAccessor);
        try (final BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            AtomicInteger numberOfTests = new AtomicInteger(0);
            AtomicInteger numberOfFailures = new AtomicInteger(0);
            AtomicInteger numberOfErrors = new AtomicInteger(0);
            AtomicInteger numberOfSkipped = new AtomicInteger(0);
            AtomicLong duration = new AtomicLong();
            StringBuilder name = new StringBuilder();
            visitor.visit(executionId, e -> {
                if (e.getStack().size() == 0) {
                    name.append(e.getNode().getName());
                    duration.set(e.getNode().getDuration().intValue());
                }
                if (e.getStack().size() == 1) {
                    numberOfTests.incrementAndGet();
                    ReportNode node = e.getNode();
                    if (node.getStatus() == ReportNodeStatus.FAILED) {
                        numberOfFailures.incrementAndGet();
                    } else if (node.getStatus() == ReportNodeStatus.TECHNICAL_ERROR) {
                        numberOfErrors.incrementAndGet();
                    } else if (node.getStatus() == ReportNodeStatus.SKIPPED) {
                        numberOfSkipped.incrementAndGet();
                    }
                }
            });
            writer.write("<testsuite name=\"" + name.toString() + "\" time=\"" + this.formatTime(duration.get()) + "\" tests=\"" + numberOfTests.get() + "\" skipped=\"" + numberOfSkipped.get() + "\" failures=\"" + numberOfFailures.get() + "\" errors=\"" + numberOfErrors.get() + "\">");
            writer.newLine();
            final AtomicBoolean errorWritten = new AtomicBoolean(false);
            visitor.visit(executionId, new ReportNodeVisitorEventHandler(){

                public void startReportNode(ReportTreeVisitor.ReportNodeEvent event) {
                    ReportNode node = event.getNode();
                    try {
                        if (event.getStack().size() == 1) {
                            if (!this.skipReportNode(node)) {
                                writer.write("<testcase classname=\"" + node.getClass().getName() + "\" name=\"" + node.getName() + "\" time=\"" + JUnit4ReportWriter.this.formatTime(node.getDuration().intValue()) + "\">");
                                errorWritten.set(false);
                            }
                        } else if (event.getStack().size() > 1 && node.getError() != null) {
                            JUnit4ReportWriter.this.writeErrorOrFailure(writer, node, errorWritten);
                        }
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                public void endReportNode(ReportTreeVisitor.ReportNodeEvent event) {
                    ReportNode node;
                    if (event.getStack().size() == 1 && !this.skipReportNode(node = event.getNode())) {
                        try {
                            if (node.getStatus() != ReportNodeStatus.PASSED && !errorWritten.get()) {
                                JUnit4ReportWriter.this.writeErrorOrFailure(writer, node, errorWritten);
                            }
                            writer.write("</testcase>");
                            writer.newLine();
                        }
                        catch (IOException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }

                protected boolean skipReportNode(ReportNode node) {
                    return node.getStatus() == ReportNodeStatus.SKIPPED || node.getStatus() == ReportNodeStatus.NORUN;
                }
            });
            writer.write("</testsuite>");
            writer.newLine();
            writer.flush();
        }
    }

    protected void writeErrorOrFailure(BufferedWriter writer, ReportNode node, AtomicBoolean errorWritten) throws IOException {
        String errorMessage = "";
        if (node.getError() != null && node.getError().getMsg() != null) {
            errorMessage = node.getError().getMsg();
        }
        if (node.getStatus() != ReportNodeStatus.PASSED) {
            if (node.getStatus() == ReportNodeStatus.FAILED) {
                writer.write("<failure type=\"\">" + errorMessage + "</failure>");
                writer.newLine();
                errorWritten.set(true);
            } else if (node.getStatus() == ReportNodeStatus.TECHNICAL_ERROR) {
                writer.write("<error type=\"\">" + errorMessage + "</error>");
                writer.newLine();
                errorWritten.set(true);
            } else {
                writer.write("<error type=\"\">No error message was reported but the status of the report node was " + node.getStatus().toString() + "</error>");
                writer.newLine();
                errorWritten.set(true);
            }
            node.getAttachments().forEach(attachment -> {});
        }
    }

    protected String formatTime(long duration) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format((double)duration / 1000.0);
    }
}

