/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.inmemory;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.datapool.DataSet;
import step.datapool.inmemory.JsonStringDataPoolConfiguration;

public class JsonStringDataPoolImpl
extends DataSet<JsonStringDataPoolConfiguration> {
    private static Logger logger = LoggerFactory.getLogger(JsonStringDataPoolImpl.class);
    Map<String, Object> map;
    int cursor = 0;

    public JsonStringDataPoolImpl(JsonStringDataPoolConfiguration configuration) {
        super((Object)configuration);
        try {
            this.map = (Map)new ObjectMapper().readValue((String)configuration.getJson().get(), HashMap.class);
        }
        catch (Exception e) {
            logger.error("Couldn't parse json string.", (Throwable)e);
            throw new RuntimeException("Couldn't parse json string. Original exception=" + e.getMessage());
        }
    }

    public void reset() {
        this.cursor = 0;
    }

    public Object next_() {
        HashMap<String, String> row = new HashMap<String, String>();
        Set<String> set = this.map.keySet();
        try {
            for (String s : set) {
                List values = (List)this.map.get(s);
                if (this.cursor >= values.size()) {
                    return null;
                }
                row.put(s, (String)values.get(this.cursor));
            }
        }
        catch (Exception e) {
            logger.error("Incorrect map content. Please follow the pattern { \"a\" : [\"va1\", \"va2\", \"va3\"], \"b\" : [\"vb1\", \"vb2\", \"vb3\"] }", (Throwable)e);
            throw new RuntimeException("Incorrect map content. Please follow the pattern { \"a\" : [\"va1\", \"va2\", \"va3\"], \"b\" : [\"vb1\", \"vb2\", \"vb3\"] }. Original exception=" + e.getMessage());
        }
        ++this.cursor;
        return row;
    }

    public void addRow(Object row) {
        throw new RuntimeException("Not implemented");
    }
}

