/*
 * Decompiled with CFR 0.152.
 */
package step.datapool.file;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.variables.SimpleStringMap;
import step.datapool.DataPoolRow;
import step.datapool.file.CSVDataPool;
import step.datapool.file.FileReaderDataPool;

public class CSVReaderDataPool
extends FileReaderDataPool {
    public static final Logger logger = LoggerFactory.getLogger(CSVReaderDataPool.class);
    protected Vector<String> headers;
    protected String delimiter;
    protected AtomicBoolean hasChanges = new AtomicBoolean(false);
    protected File tempFile;
    protected PrintWriter tempFileWriter;

    public CSVReaderDataPool(CSVDataPool configuration) {
        super(configuration);
        this.delimiter = (String)configuration.getDelimiter().get();
    }

    @Override
    public void init() {
        super.init();
        this.tempFile = new File(this.filePath + ".tmp");
        try {
            this.tempFileWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.tempFile)));
            Iterator<String> iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                String header = iterator.next();
                this.tempFileWriter.write(header);
                if (!iterator.hasNext()) continue;
                this.tempFileWriter.write(this.delimiter);
            }
            this.tempFileWriter.println();
        }
        catch (IOException e) {
            logger.error("Error while creating temporary file " + this.tempFile.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            this.tempFileWriter.close();
            if (this.hasChanges.get()) {
                File initialFile = new File(this.filePath + ".initial");
                Files.move((File)new File(this.filePath), (File)initialFile);
                Files.move((File)this.tempFile, (File)new File(this.filePath));
                initialFile.delete();
            }
            this.tempFile.delete();
        }
        catch (IOException e) {
            logger.error("Error while closing the CSV dataset", (Throwable)e);
        }
    }

    public void writeRow(DataPoolRow row) throws IOException {
        super.writeRow(row);
        Object value = row.getValue();
        if (value != null && value instanceof CSVRowWrapper) {
            CSVRowWrapper csvRow = (CSVRowWrapper)((Object)value);
            Iterator<String> iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                String header = iterator.next();
                this.tempFileWriter.print(csvRow.rowData.get(header).toString());
                if (!iterator.hasNext()) continue;
                this.tempFileWriter.print(this.delimiter);
            }
            this.tempFileWriter.println();
        }
    }

    @Override
    public Object postProcess(String line) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Vector<String> csv = this.splitCSV(line);
            for (int i = 0; i < csv.size(); ++i) {
                map.put(this.headers.get(i), csv.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException(e.getMessage() + " : headers=" + this.headers + "; row=" + line + "; delimiter=" + this.delimiter);
        }
        return new CSVRowWrapper(this.lineNr, map);
    }

    public Vector<String> getHeaders(String readOneLine) {
        return this.splitCSV(readOneLine);
    }

    public Vector<String> splitCSV(String readOneLine) {
        Vector<String> v = new Vector<String>();
        for (String s : readOneLine.split(this.delimiter, -1)) {
            v.add(s);
        }
        return v;
    }

    @Override
    public void doFirst_() {
        this.headers = this.getHeaders(this.readOneLine());
    }

    public void addRow(Object row) {
        throw new RuntimeException("Not implemented");
    }

    public class CSVRowWrapper
    extends SimpleStringMap {
        private HashMap<String, Object> rowData;

        public CSVRowWrapper(int rowNum, HashMap<String, Object> row) {
            if (rowNum < 1) {
                throw new RuntimeException("Invalid row number:" + rowNum);
            }
            this.rowData = row;
        }

        public String put(String key, String value) {
            if (!CSVReaderDataPool.this.isRowCommitEnabled) {
                throw new RuntimeException("Row commit disabled. Writing to CSV data sets is not supported in this mode.");
            }
            this.rowData.put(key, value);
            CSVReaderDataPool.this.hasChanges.set(true);
            return value;
        }

        public String get(String key) {
            return (String)this.rowData.get(key);
        }

        public int size() {
            return this.rowData.size();
        }

        public boolean isEmpty() {
            return this.rowData.isEmpty();
        }

        public Set<String> keySet() {
            return new HashSet<String>(CSVReaderDataPool.this.headers);
        }
    }
}

