/*
 * Decompiled with CFR 0.152.
 */
package io.denkbar.smb.core;

import io.denkbar.smb.core.Message;
import io.denkbar.smb.core.MessageListener;
import io.denkbar.smb.core.MessageRouterStateListener;
import io.denkbar.smb.core.RemoteException;
import io.denkbar.smb.core.SynchronMessage;
import io.denkbar.smb.core.SynchronMessageListener;
import io.denkbar.smb.core.SynchronMessageResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRouter
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MessageRouter.class);
    private static final String ALL_MESSAGES_LISTENER = "##all##";
    private final ConcurrentHashMap<Integer, SynchronMessageResponseHolder> register = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<MessageListener>> permanentRegister = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SynchronMessageListener> synchronListenerRegister = new ConcurrentHashMap();
    private final AtomicInteger seq = new AtomicInteger();
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private final Socket socket;
    private final ObjectOutputStream out;
    private final ObjectInputStream in;
    private final MessageRouterStateListener stateListener;
    private boolean connected;

    public MessageRouter(String host, Integer port) throws UnknownHostException, IOException {
        this(null, new Socket(host, (int)port));
    }

    public MessageRouter(MessageRouterStateListener listener, String host, Integer port) throws UnknownHostException, IOException {
        this(listener, new Socket(host, (int)port));
    }

    public MessageRouter(MessageRouterStateListener listener, Socket socket) throws IOException {
        this.socket = socket;
        this.out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        this.connected = true;
        this.stateListener = listener;
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    Message message = null;
                    try {
                        message = (Message)this.in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        this.handleException(e);
                    }
                    if (message == null) continue;
                    try {
                        this.dispatch(message);
                        continue block6;
                    }
                    catch (Exception e) {
                        logger.error("Error while dispatching message " + message.getType(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.handleException(e);
                return;
            }
        }
    }

    private void handleException(Exception e) {
        this.connected = false;
        if (!(e instanceof SocketException)) {
            logger.error("Unexpected error", (Throwable)e);
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.stateListener != null) {
            this.stateListener.messageRouterDisconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Message m) {
        if (m instanceof SynchronMessage) {
            if (m instanceof SynchronMessageResponse) {
                SynchronMessageResponse response = (SynchronMessageResponse)m;
                SynchronMessageResponseHolder responseHolder = this.register.remove(response.getCorrelationID());
                if (responseHolder != null) {
                    SynchronMessageResponseHolder synchronMessageResponseHolder = responseHolder;
                    synchronized (synchronMessageResponseHolder) {
                        responseHolder.processed = true;
                        responseHolder.exception = ((SynchronMessageResponse)m).getException();
                        responseHolder.response = m.getContent();
                        responseHolder.notify();
                    }
                }
            } else {
                SynchronMessage message = (SynchronMessage)m;
                SynchronMessageListener listener = this.synchronListenerRegister.get(message.getType());
                if (listener != null) {
                    this.executor.submit(new CallSynchronListenerTask(listener, message));
                }
            }
        } else {
            this.submitCallListenerTask(m, this.permanentRegister.get(m.getType()));
            this.submitCallListenerTask(m, this.permanentRegister.get(ALL_MESSAGES_LISTENER));
        }
    }

    private void submitCallListenerTask(Message m, List<MessageListener> listeners) {
        if (listeners != null) {
            for (MessageListener listener : listeners) {
                this.executor.submit(new CallListenerTask(listener, m));
            }
        }
    }

    public void sendMessage(String command) throws IOException {
        this.sendMessage(command, null);
    }

    public void sendMessage(String command, Object content) throws IOException {
        this.send(new Message(command, content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            try {
                this.out.writeObject(message);
                this.out.reset();
                this.out.flush();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Message message, long timeout) throws Exception {
        int correlationID = this.seq.incrementAndGet();
        SynchronMessageResponseHolder responseHholder = new SynchronMessageResponseHolder();
        SynchronMessage synchronMessage = new SynchronMessage(message.getType(), message.getContent(), correlationID);
        this.register.put(correlationID, responseHholder);
        this.send(synchronMessage);
        SynchronMessageResponseHolder synchronMessageResponseHolder = responseHholder;
        synchronized (synchronMessageResponseHolder) {
            if (!responseHholder.processed) {
                responseHholder.wait(timeout);
            }
        }
        if (responseHholder.processed) {
            if (responseHholder.exception != null) {
                throw responseHholder.exception;
            }
            return responseHholder.response;
        }
        throw new TimeoutException("Timeout occurred while calling " + message.getType());
    }

    public synchronized void registerPermanentListener(String type, MessageListener listener) {
        if (!this.permanentRegister.containsKey(type)) {
            this.permanentRegister.put(type, new ArrayList());
        }
        this.permanentRegister.get(type).add(listener);
    }

    public synchronized void registerPermanentListenerForAllMessages(MessageListener listener) {
        this.registerPermanentListener(ALL_MESSAGES_LISTENER, listener);
    }

    public synchronized void registerSynchronListener(String type, SynchronMessageListener listener) {
        if (this.synchronListenerRegister.containsKey(type)) {
            throw new RuntimeException("Only one SynchronMessageListener can be registered. A message listener is already registered for the message type " + type);
        }
        this.synchronListenerRegister.put(type, listener);
    }

    public synchronized void unregisterPermanentListener(String type, MessageListener listener) {
        if (this.permanentRegister.containsKey(type)) {
            this.permanentRegister.get(type).remove(listener);
        }
    }

    public void disconnect() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    public boolean isConnected() {
        return this.connected;
    }

    private class SynchronMessageResponseHolder {
        public boolean processed = false;
        public Object response;
        public Exception exception;

        private SynchronMessageResponseHolder() {
        }
    }

    private class CallSynchronListenerTask
    implements Runnable {
        private final SynchronMessageListener listener;
        private final SynchronMessage msg;

        public CallSynchronListenerTask(SynchronMessageListener listener, SynchronMessage msg) {
            this.listener = listener;
            this.msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Serializable reponse = null;
            Exception exception = null;
            try {
                System.out.println("Received message: " + this.msg.getType());
                reponse = this.listener.onSynchronMessage(this.msg);
                RemoteException remoteException = null;
                if (exception != null) {
                    remoteException = new RemoteException(exception);
                }
                SynchronMessageResponse response = new SynchronMessageResponse(this.msg.getType(), reponse, this.msg.getCorrelationID(), remoteException);
                MessageRouter.this.send(response);
            }
            catch (Exception e) {
                try {
                    exception = e;
                    RemoteException remoteException = null;
                    if (exception != null) {
                        remoteException = new RemoteException(exception);
                    }
                    SynchronMessageResponse response = new SynchronMessageResponse(this.msg.getType(), reponse, this.msg.getCorrelationID(), remoteException);
                    MessageRouter.this.send(response);
                }
                catch (Throwable throwable) {
                    RemoteException remoteException = null;
                    if (exception != null) {
                        remoteException = new RemoteException(exception);
                    }
                    SynchronMessageResponse response = new SynchronMessageResponse(this.msg.getType(), reponse, this.msg.getCorrelationID(), remoteException);
                    MessageRouter.this.send(response);
                    throw throwable;
                }
            }
        }
    }

    private class CallListenerTask
    implements Runnable {
        private final MessageListener listener;
        private final Message msg;

        public CallListenerTask(MessageListener listener, Message msg) {
            this.listener = listener;
            this.msg = msg;
        }

        public void run() {
            try {
                logger.debug("Received message: " + this.msg.getType());
                this.listener.onMessage(this.msg);
            }
            catch (Exception e) {
                logger.error("Error while calling listener " + this.listener.getClass().getCanonicalName(), (Throwable)e);
            }
        }
    }
}

