/*
 * Decompiled with CFR 0.152.
 */
package org.rtm.commons;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.rtm.commons.Configuration;
import org.rtm.commons.MeasurementDBConverter;
import org.rtm.commons.TransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementAccessor
implements TransportClient {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementAccessor.class);
    private static MeasurementAccessor INSTANCE = new MeasurementAccessor();
    private MongoClient mongo = null;
    private MongoDatabase db = null;
    private MongoCollection<Document> coll = null;
    private String host = null;
    private Integer port = null;
    private String user = null;
    private String pwd = null;
    private String database = null;

    private MeasurementAccessor() {
        Configuration conf = Configuration.getInstance();
        String stringAttempt1 = null;
        String stringAttempt2 = null;
        try {
            stringAttempt1 = conf.getProperty("db.host");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringAttempt2 = conf.getProperty("ds.host");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.host = stringAttempt1 == null || stringAttempt1.isEmpty() ? (stringAttempt2 == null || stringAttempt2.isEmpty() ? "localhost" : stringAttempt2) : stringAttempt1;
        Integer intAttempt1 = null;
        Integer intAttempt2 = null;
        try {
            intAttempt1 = conf.getPropertyAsInteger("db.port");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            intAttempt2 = conf.getPropertyAsInteger("ds.port");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = intAttempt1 == null || intAttempt1 <= 0 ? (intAttempt2 == null || intAttempt2 <= 0 ? 27017 : intAttempt2) : intAttempt1;
        stringAttempt1 = null;
        stringAttempt2 = null;
        try {
            stringAttempt1 = conf.getProperty("db.username");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringAttempt2 = conf.getProperty("ds.username");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.user = stringAttempt1 == null || stringAttempt1.isEmpty() ? (stringAttempt2 == null || stringAttempt2.isEmpty() ? null : stringAttempt2) : stringAttempt1;
        stringAttempt1 = null;
        stringAttempt2 = null;
        try {
            stringAttempt1 = conf.getProperty("db.password");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringAttempt2 = conf.getProperty("ds.password");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pwd = stringAttempt1 == null || stringAttempt1.isEmpty() ? (stringAttempt2 == null || stringAttempt2.isEmpty() ? null : stringAttempt2) : stringAttempt1;
        stringAttempt1 = null;
        stringAttempt2 = null;
        try {
            stringAttempt1 = conf.getProperty("db.database");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringAttempt2 = conf.getProperty("ds.dbname");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.database = stringAttempt1 == null || stringAttempt1.isEmpty() ? (stringAttempt2 == null || stringAttempt2.isEmpty() ? "rtm" : stringAttempt2) : stringAttempt1;
        ServerAddress address = new ServerAddress(this.host, this.port.intValue());
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (this.user != null) {
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)this.user, (String)this.database, (char[])this.pwd.toCharArray());
            credentials.add(credential);
        }
        String collName = null;
        try {
            collName = conf.getProperty("ds.measurements.collectionName");
        }
        catch (Exception e) {
            logger.error("Fatal config issue.", (Throwable)e);
        }
        logger.info("Initializing db with address=" + address + ", credentials=" + credentials + ", database=" + this.database + ", collection=" + collName);
        this.mongo = new MongoClient(address, credentials);
        this.db = this.mongo.getDatabase(this.database);
        this.coll = this.db.getCollection(collName);
        if (this.mongo == null || this.db == null || this.mongo.getAddress() == null || this.coll == null) {
            logger.error("Mongo is down.");
        }
    }

    public static MeasurementAccessor getInstance() {
        return INSTANCE;
    }

    @Override
    public void sendStructuredMeasurement(Map<String, Object> m) {
        this.saveMeasurementInternal(new Document(m));
    }

    @Override
    public void sendStructuredMeasurement(String m) {
        this.saveMeasurementInternal(MeasurementDBConverter.convertToMongo(m));
    }

    private void saveMeasurementInternal(Document m) {
        this.coll.insertOne((Object)m);
    }

    public void saveManyMeasurements(List<Object> lm) {
        this.saveManyMeasurementsInternal(MeasurementDBConverter.convertManyToMongo(lm));
    }

    public void saveManyMeasurementsInternal(List<Document> lm) {
        this.coll.insertMany(lm);
    }

    public void removeOneViaPattern(Map<String, Object> m) {
        this.coll.deleteOne((Bson)new Document(m));
    }

    public void removeManyViaPatternList(List<Map<String, Object>> lm) {
        lm.stream().forEach(m -> this.removeOneViaPattern((Map<String, Object>)m));
    }

    public void removeManyViaPattern(Map<String, Object> m) {
        this.coll.deleteMany((Bson)new Document(m));
    }

    public long getMeasurementCount() {
        return this.coll.count();
    }

    public Iterable<Document> find(Bson filter) {
        return this.coll.find(filter);
    }

    public Iterable<Document> find(Bson filter, Bson sortOrder) {
        return this.coll.find(filter).sort(sortOrder);
    }

    public Iterable<Document> find(Bson filter, Bson sortOrder, int skip, int limit) {
        return this.coll.find(filter).skip(skip).limit(limit);
    }

    @Override
    public void close() {
        this.mongo.close();
    }
}

