/*
 * Decompiled with CFR 0.152.
 */
package org.rtm.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final String CONFIG_FILENAME = "rtm.properties";
    private static Configuration INSTANCE;
    private Properties properties = new Properties();

    @Deprecated
    private Configuration() {
        String configFile = CONFIG_FILENAME;
        try {
            InputStream instream = this.getClass().getClassLoader().getResourceAsStream(configFile);
            this.properties.load(instream);
            INSTANCE = this;
        }
        catch (Exception e) {
            String msg = "Could not read configuration file from the classpath: " + configFile;
            logger.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private Configuration(File f) {
        String configFile = CONFIG_FILENAME;
        try {
            FileInputStream instream = new FileInputStream(f);
            this.properties.load(instream);
            INSTANCE = this;
        }
        catch (Exception e) {
            String msg = "Could not read configuration file from the classpath: " + configFile;
            logger.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    public static void initSingleton(File f) {
        INSTANCE = new Configuration(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            INSTANCE = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public boolean hasProperty(String key) {
        return this.properties.getProperty(key) != null;
    }

    public String getPropertyWithDefault(String name, String defaultValue) {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return prop;
        }
        return defaultValue;
    }

    public String getProperty(String name) throws Exception {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return prop;
        }
        throw new Exception("Configuration issue - property not found: " + name);
    }

    public String getProperty(String name, String defaultValue) {
        try {
            return this.getProperty(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Integer getPropertyAsInteger(String name) throws Exception {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        throw new Exception("Configuration issue - property not found: " + name);
    }

    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        try {
            return this.getPropertyAsInteger(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getPropertyAsBoolean(String name) throws Exception {
        String prop = this.properties.getProperty(name);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        throw new Exception("Configuration issue - property not found: " + name);
    }

    public Properties getUnderlyingPropertyObject() {
        return this.properties;
    }
}

