/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.commons.processes;

import ch.exense.commons.processes.ManagedProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExternalJVMLauncher {
    private final String javaPath;
    private final File processLogFolder;

    public ExternalJVMLauncher(String javaPath, File processLogFolder) {
        this.javaPath = javaPath;
        this.processLogFolder = processLogFolder;
    }

    private String buildClasspath() {
        String pathSeparator = System.getProperty("path.separator");
        String[] classPathEntries = System.getProperty("java.class.path").split(pathSeparator);
        StringBuilder cp = new StringBuilder();
        String delimiter = ExternalJVMLauncher.isWindows() ? ";" : ":";
        cp.append("\"");
        for (String url : classPathEntries) {
            cp.append(url + delimiter);
        }
        cp.append("\"");
        return cp.toString();
    }

    public ManagedProcess launchExternalJVM(String name, Class<?> mainClass, List<String> vmargs, List<String> progargs) throws ManagedProcess.ManagedProcessException {
        return this.launchExternalJVM(name, mainClass, vmargs, progargs, true);
    }

    public ManagedProcess launchExternalJVM(String name, Class<?> mainClass, List<String> vmargs, List<String> progargs, boolean redirectOutput) throws ManagedProcess.ManagedProcessException {
        String cp = this.buildClasspath();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.javaPath);
        cmd.add("-cp");
        cmd.add(cp);
        cmd.addAll(vmargs);
        cmd.add(mainClass.getName());
        cmd.addAll(progargs);
        ManagedProcess process = new ManagedProcess(name, cmd, this.processLogFolder, redirectOutput);
        process.start();
        return process;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }
}

