/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.commons.io;

import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class Poller {
    public static void waitFor(Supplier<Boolean> predicate, long timeout) throws TimeoutException, InterruptedException {
        Poller.waitFor(predicate, timeout, 100L);
    }

    public static void waitFor(Supplier<Boolean> predicate, long timeout, long pollingIntervalMs) throws TimeoutException, InterruptedException {
        long t1 = System.currentTimeMillis();
        while (timeout == 0L || System.currentTimeMillis() < t1 + timeout) {
            boolean result = predicate.get();
            if (result) {
                return;
            }
            Thread.sleep(pollingIntervalMs);
        }
        throw new TimeoutException();
    }
}

