/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.util;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.util.LogMarkers;

public class APIException
extends RuntimeException {
    private final Error error;

    public APIException(String message, Integer code) {
        super(message);
        switch (code) {
            case 404: {
                this.error = Error.NOT_FOUND;
                break;
            }
            case 403: {
                this.error = Error.FORBIDDEN;
                break;
            }
            case 424: {
                this.error = Error.FAILED_DEPENDENCY;
                break;
            }
            default: {
                GECo4J.LOGGER.error(LogMarkers.API, "Invalid error code: {}", (Object)code);
                this.error = null;
            }
        }
    }

    public Error getError() {
        return this.error;
    }

    public static enum Error {
        NOT_FOUND,
        FORBIDDEN,
        FAILED_DEPENDENCY;

    }
}

