/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.internal;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.obj.GECoClient;
import ch.ethz.geco.g4j.util.APIException;
import ch.ethz.geco.g4j.util.GECo4JException;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.annotation.Nullable;

public class Requests {
    private final GECoClient gecoClient;
    private final HttpClient httpClient;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public Requests(GECoClient client) {
        this.gecoClient = client;
        this.httpClient = HttpClient.create().headers(h -> {
            h.add("X-API-KEY", (Object)client.getAPIToken());
            h.add("Content-Type", (Object)"application/json");
        }).baseUrl("https://geco.ethz.ch/api/v2");
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        byte[] buf = new byte[8192];
        int capacity = buf.length;
        int nread = 0;
        while (true) {
            int n;
            if ((n = inputStream.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity <<= 1;
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    private <T> Mono<T> makeAndroidRequest(METHOD method, String url, Class<T> clazz, String content) {
        return Mono.fromSupplier(() -> 0).flatMap(a -> {
            try {
                HttpURLConnection request = (HttpURLConnection)new URL(url).openConnection();
                request.setRequestProperty("X-API-KEY", this.gecoClient.getAPIToken());
                request.setRequestProperty("Content-Type", "application/json");
                request.setRequestMethod(method.name());
                if (content != null && method != METHOD.GET) {
                    request.setDoOutput(true);
                    OutputStream outputStream = request.getOutputStream();
                    outputStream.write(content.getBytes(StandardCharsets.UTF_8));
                    outputStream.close();
                }
                request.connect();
                int responseCode = request.getResponseCode();
                InputStream inputStream = request.getInputStream();
                byte[] bytes = this.readAllBytes(inputStream);
                String data = new String(bytes, StandardCharsets.UTF_8);
                GECo4J.LOGGER.trace(LogMarkers.API, "Response: {} {}", (Object)responseCode, (Object)(data.isEmpty() ? "EMPTY" : data));
                if (responseCode == 403 || responseCode == 404 || responseCode == 424) {
                    JsonNode jsonNode = GECoUtils.MAPPER.readTree(data);
                    JsonNode message = jsonNode.get("message");
                    JsonNode code = jsonNode.get("code");
                    if (code == null) {
                        return Mono.error((Throwable)new GECo4JException("Error on request to " + request.getURL() + ". Received response code " + responseCode + ". With response text: " + data));
                    }
                    return Mono.error((Throwable)new APIException(message != null ? message.asText() : "None", code.asInt()));
                }
                if (responseCode < 200 || responseCode > 299) {
                    return Mono.error((Throwable)new GECo4JException("Error on request to " + request.getURL() + ". Received response code " + responseCode + ". With response text: " + data));
                }
                return Mono.just((Object)GECoUtils.MAPPER.readValue(data, clazz));
            }
            catch (IOException e) {
                e.printStackTrace();
                return Mono.empty();
            }
        });
    }

    public <T> Mono<T> makeRequest(METHOD method, String url, Class<T> clazz, @Nullable String content) {
        if (System.getProperty("java.vm.vendor", "").equals("The Android Project")) {
            GECo4J.LOGGER.trace(LogMarkers.API, "ANDROID {} - {}", (Object)method.name(), (Object)url);
            return this.makeAndroidRequest(method, "https://geco.ethz.ch/api/v2" + url, clazz, content).subscribeOn(Schedulers.single());
        }
        GECo4J.LOGGER.trace(LogMarkers.API, "{} - {}", (Object)method.name(), (Object)url);
        HttpClient.ResponseReceiver receiver = null;
        switch (method) {
            case GET: {
                receiver = (HttpClient.ResponseReceiver)this.httpClient.get().uri(url);
                break;
            }
            case POST: {
                receiver = ((HttpClient.RequestSender)this.httpClient.post().uri(url)).send((Publisher)ByteBufFlux.fromString((Publisher)(content != null ? Flux.just((Object)content) : Flux.empty())));
                break;
            }
            case PATCH: {
                receiver = ((HttpClient.RequestSender)this.httpClient.patch().uri(url)).send((Publisher)ByteBufFlux.fromString((Publisher)(content != null ? Flux.just((Object)content) : Flux.empty())));
                break;
            }
            case DELETE: {
                receiver = ((HttpClient.RequestSender)this.httpClient.delete().uri(url)).send((Publisher)ByteBufFlux.fromString((Publisher)(content != null ? Flux.just((Object)content) : Flux.empty())));
            }
        }
        return receiver.responseSingle((response, responseContent) -> {
            int responseCode = response.status().code();
            return responseContent.asString().defaultIfEmpty((Object)"EMPTY").flatMap(data -> {
                GECo4J.LOGGER.trace(LogMarkers.API, "Response: {} {}", (Object)responseCode, data);
                if (responseCode == 403 || responseCode == 404 || responseCode == 424) {
                    try {
                        JsonNode jsonNode = GECoUtils.MAPPER.readTree(data);
                        JsonNode message = jsonNode.get("message");
                        JsonNode code = jsonNode.get("code");
                        if (code == null) {
                            return Mono.error((Throwable)new GECo4JException("Error on request to " + response.uri() + ". Received response code " + responseCode + ". With response text: " + data));
                        }
                        return Mono.error((Throwable)new APIException(message != null ? message.asText() : "None", code.asInt()));
                    }
                    catch (IOException e) {
                        return Mono.error((Throwable)e);
                    }
                }
                if (responseCode < 200 || responseCode > 299) {
                    return Mono.error((Throwable)new GECo4JException("Error on request to " + response.uri() + ". Received response code " + responseCode + ". With response text: " + data));
                }
                try {
                    if (clazz == null) {
                        return Mono.empty();
                    }
                    return Mono.just((Object)GECoUtils.MAPPER.readValue(data, clazz));
                }
                catch (IOException e) {
                    return Mono.error((Throwable)e);
                }
            });
        });
    }

    public static enum METHOD {
        GET,
        POST,
        DELETE,
        PATCH;

    }
}

