/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j;

import ch.ethz.geco.g4j.util.LogMarkers;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.time.LocalTime;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NOPLoggerFactory;

public class GECo4J {
    private static final String NAME;
    private static final String VERSION;
    private static final String COMMIT;
    private static final String BRANCH;
    private static final String DESCRIPTION;
    private static final String URL;
    public static final Logger LOGGER;
    protected static final Instant launchTime;

    private static Logger initLogger() {
        if (!GECo4J.isSLF4JImplementationPresent()) {
            System.err.println("GECo4J: ERROR INITIALIZING LOGGER!");
            System.err.println("GECo4J: No SLF4J implementation found, reverting to the internal implementation (" + GECo4JLogger.class.getName() + ")");
            System.err.println("GECo4J: It is *highly* recommended to use a fully featured implementation like logback!");
            return new GECo4JLogger(GECo4J.class.getName());
        }
        return LoggerFactory.getLogger(GECo4J.class);
    }

    private static boolean isSLF4JImplementationPresent() {
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return !(LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        LOGGER = GECo4J.initLogger();
        launchTime = Instant.now();
        InputStream stream = GECo4J.class.getClassLoader().getResourceAsStream("lib.properties");
        if (stream == null) {
            System.err.println("Could not load lib.properties.");
            System.exit(1);
        }
        Properties properties = new Properties();
        try {
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.MAIN, "GECo4J Internal Exception", (Throwable)e);
        }
        NAME = properties.getProperty("library.name");
        VERSION = properties.getProperty("library.version");
        COMMIT = properties.getProperty("library.git.commit");
        BRANCH = properties.getProperty("library.git.branch");
        DESCRIPTION = properties.getProperty("library.description");
        URL = properties.getProperty("library.url");
        LOGGER.info(LogMarkers.MAIN, "{} v{} {} ({})", new Object[]{NAME, VERSION, COMMIT, URL});
        LOGGER.info(LogMarkers.MAIN, "{}", (Object)DESCRIPTION);
    }

    public static class GECo4JLogger
    extends MarkerIgnoringBase {
        private final String name;
        private volatile int level = Level.INFO.ordinal();
        private volatile PrintStream standard;
        private volatile PrintStream error;

        GECo4JLogger(String name) {
            this.name = name;
            this.standard = System.out;
            this.error = System.err;
        }

        public void setLevel(Level level) {
            this.level = level.ordinal();
        }

        public void setStandardStream(PrintStream stream) {
            this.standard = stream;
        }

        public void setErrorStream(PrintStream stream) {
            this.error = stream;
        }

        private void log(Level level, String message, Throwable error) {
            if (level.ordinal() >= this.level) {
                PrintStream stream = level.ordinal() >= Level.WARN.ordinal() ? this.error : this.standard;
                stream.format("%s: [%s][%s][%s] - %s\n", new Object[]{LocalTime.now(), level, Thread.currentThread().getName(), this.name, message});
                if (error != null) {
                    error.printStackTrace(stream);
                }
            }
        }

        public boolean isTraceEnabled() {
            return this.level == Level.TRACE.ordinal();
        }

        public void trace(String msg) {
            this.log(Level.TRACE, msg, null);
        }

        public void trace(String format, Object arg) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.TRACE, tuple.getMessage(), tuple.getThrowable());
        }

        public void trace(String format, Object arg1, Object arg2) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.TRACE, tuple.getMessage(), tuple.getThrowable());
        }

        public void trace(String format, Object ... arguments) {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(Level.TRACE, tuple.getMessage(), tuple.getThrowable());
        }

        public void trace(String msg, Throwable t) {
            this.log(Level.TRACE, msg, t);
        }

        public boolean isDebugEnabled() {
            return this.level <= Level.DEBUG.ordinal();
        }

        public void debug(String msg) {
            this.log(Level.DEBUG, msg, null);
        }

        public void debug(String format, Object arg) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.DEBUG, tuple.getMessage(), tuple.getThrowable());
        }

        public void debug(String format, Object arg1, Object arg2) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.DEBUG, tuple.getMessage(), tuple.getThrowable());
        }

        public void debug(String format, Object ... arguments) {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(Level.DEBUG, tuple.getMessage(), tuple.getThrowable());
        }

        public void debug(String msg, Throwable t) {
            this.log(Level.DEBUG, msg, t);
        }

        public boolean isInfoEnabled() {
            return this.level <= Level.INFO.ordinal();
        }

        public void info(String msg) {
            this.log(Level.INFO, msg, null);
        }

        public void info(String format, Object arg) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.INFO, tuple.getMessage(), tuple.getThrowable());
        }

        public void info(String format, Object arg1, Object arg2) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.INFO, tuple.getMessage(), tuple.getThrowable());
        }

        public void info(String format, Object ... arguments) {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(Level.INFO, tuple.getMessage(), tuple.getThrowable());
        }

        public void info(String msg, Throwable t) {
            this.log(Level.INFO, msg, t);
        }

        public boolean isWarnEnabled() {
            return this.level <= Level.WARN.ordinal();
        }

        public void warn(String msg) {
            this.log(Level.WARN, msg, null);
        }

        public void warn(String format, Object arg) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.WARN, tuple.getMessage(), tuple.getThrowable());
        }

        public void warn(String format, Object arg1, Object arg2) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.WARN, tuple.getMessage(), tuple.getThrowable());
        }

        public void warn(String format, Object ... arguments) {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(Level.WARN, tuple.getMessage(), tuple.getThrowable());
        }

        public void warn(String msg, Throwable t) {
            this.log(Level.WARN, msg, t);
        }

        public boolean isErrorEnabled() {
            return this.level <= Level.ERROR.ordinal();
        }

        public void error(String msg) {
            this.log(Level.ERROR, msg, null);
        }

        public void error(String format, Object arg) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg);
            this.log(Level.ERROR, tuple.getMessage(), tuple.getThrowable());
        }

        public void error(String format, Object arg1, Object arg2) {
            FormattingTuple tuple = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.log(Level.ERROR, tuple.getMessage(), tuple.getThrowable());
        }

        public void error(String format, Object ... arguments) {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this.log(Level.ERROR, tuple.getMessage(), tuple.getThrowable());
        }

        public void error(String msg, Throwable t) {
            this.log(Level.ERROR, msg, t);
        }

        public static enum Level {
            TRACE,
            DEBUG,
            INFO,
            WARN,
            ERROR,
            NONE;

        }
    }
}

