/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.impl;

import ch.ethz.geco.g4j.impl.DefaultGECoClient;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.internal.Requests;
import ch.ethz.geco.g4j.internal.json.BorrowItemRequest;
import ch.ethz.geco.g4j.internal.json.BorrowedItemObject;
import ch.ethz.geco.g4j.internal.json.CheckinRequest;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.VerifyRequest;
import ch.ethz.geco.g4j.obj.BorrowedItem;
import ch.ethz.geco.g4j.obj.GECoClient;
import ch.ethz.geco.g4j.obj.LanUser;
import ch.ethz.geco.g4j.obj.Seat;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebLanUser
implements LanUser {
    private final GECoClient client;
    private final Long id;
    private final String statusMessage;
    private final LanUser.Status status;
    private final String username;
    private final String firstName;
    private final String lastName;
    private final String seatName;
    private final Long birthday;
    private final Boolean isVerified;
    private final String legiNumber;
    private final String lanPackage;
    private final String studentAssoc;

    public WebLanUser(GECoClient client, Long id, String statusMessage, LanUser.Status status, String username, String firstName, String lastName, String seatName, Long birthday, Boolean isVerified, String legiNumber, String lanPackage, String studentAssoc) {
        this.client = client;
        this.id = id;
        this.statusMessage = statusMessage;
        this.status = status;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.seatName = seatName;
        this.birthday = birthday;
        this.isVerified = isVerified;
        this.legiNumber = legiNumber;
        this.lanPackage = lanPackage;
        this.studentAssoc = studentAssoc;
        if (lanPackage.equalsIgnoreCase("external")) {
            this.setVerification(true, "none").block();
        }
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public LanUser.Status getStatus() {
        return this.status;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getFullName() {
        return this.firstName + " " + this.lastName;
    }

    @Override
    public Optional<String> getSeatName() {
        return Optional.ofNullable(this.seatName);
    }

    @Override
    public Mono<Seat> getSeat() {
        if (this.seatName == null) {
            return Mono.empty();
        }
        return this.client.getSeatByName(this.seatName);
    }

    @Override
    public Long getBirthDay() {
        return this.birthday;
    }

    @Override
    public Boolean isVerified() {
        return this.isVerified;
    }

    @Override
    public Optional<String> getLegiNumber() {
        return Optional.ofNullable(this.legiNumber);
    }

    @Override
    public String getLANPackage() {
        return this.lanPackage;
    }

    @Override
    public Optional<String> getStudentAssoc() {
        return Optional.ofNullable(this.studentAssoc);
    }

    @Override
    public Mono<LanUser> setVerification(Boolean isVerified, String legiNumber) {
        String content;
        try {
            content = GECoUtils.MAPPER.writeValueAsString((Object)new VerifyRequest(isVerified, legiNumber));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
        return ((DefaultGECoClient)this.client).REQUESTS.makeRequest(Requests.METHOD.PATCH, "/lan/user/" + this.id + "/verify", LanUserObject.class, content).map(lanUserObject -> GECoUtils.getLanUserFromJSON(this.client, lanUserObject));
    }

    @Override
    public Mono<LanUser> checkin(String checkinString) {
        String content;
        try {
            content = GECoUtils.MAPPER.writeValueAsString((Object)new CheckinRequest(checkinString));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
        return ((DefaultGECoClient)this.client).REQUESTS.makeRequest(Requests.METHOD.PATCH, "/lan/user/" + this.id + "/checkin", LanUserObject.class, content).map(lanUserObject -> GECoUtils.getLanUserFromJSON(this.client, lanUserObject));
    }

    @Override
    public Flux<BorrowedItem> getBorrowedItems() {
        return ((DefaultGECoClient)this.client).REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/user/" + this.id + "/items", BorrowedItemObject[].class, null).flatMapMany(borrowedItemObjects -> {
            Object[] borrowedItems = new BorrowedItem[((BorrowedItemObject[])borrowedItemObjects).length];
            for (int i = 0; i < ((BorrowedItemObject[])borrowedItemObjects).length; ++i) {
                borrowedItems[i] = GECoUtils.getBorrowedItemFromJSON(this.client, borrowedItemObjects[i], this.id);
            }
            return Flux.fromArray((Object[])borrowedItems);
        });
    }

    @Override
    public Mono<BorrowedItem> getBorrowedItemByID(Long id) {
        return this.getBorrowedItems().filter(borrowedItem -> borrowedItem.getID().equals(id)).single();
    }

    @Override
    public Mono<BorrowedItem> borrowItem(String name) {
        String content;
        try {
            content = GECoUtils.MAPPER.writeValueAsString((Object)new BorrowItemRequest(name));
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)e);
        }
        return ((DefaultGECoClient)this.client).REQUESTS.makeRequest(Requests.METHOD.POST, "/lan/user/" + this.id + "/items", BorrowedItemObject.class, content).map(borrowedItemObject -> GECoUtils.getBorrowedItemFromJSON(this.client, borrowedItemObject, this.id));
    }
}

