/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.internal;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.impl.WebBorrowedItem;
import ch.ethz.geco.g4j.impl.WebEvent;
import ch.ethz.geco.g4j.impl.WebLanUser;
import ch.ethz.geco.g4j.impl.WebNews;
import ch.ethz.geco.g4j.impl.WebSeat;
import ch.ethz.geco.g4j.impl.WebUser;
import ch.ethz.geco.g4j.internal.json.BorrowedItemObject;
import ch.ethz.geco.g4j.internal.json.EventObject;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.NewsObject;
import ch.ethz.geco.g4j.internal.json.SeatObject;
import ch.ethz.geco.g4j.internal.json.UserObject;
import ch.ethz.geco.g4j.obj.BorrowedItem;
import ch.ethz.geco.g4j.obj.Event;
import ch.ethz.geco.g4j.obj.GECoClient;
import ch.ethz.geco.g4j.obj.LanUser;
import ch.ethz.geco.g4j.obj.News;
import ch.ethz.geco.g4j.obj.Seat;
import ch.ethz.geco.g4j.obj.User;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.databind.ObjectMapper;

public class GECoUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static User getUserFromJSON(UserObject userObject) {
        return new WebUser(userObject.id, userObject.name, userObject.usergroup, userObject.lol, userObject.steam, userObject.bnet, userObject.discord);
    }

    public static Seat getSeatFromJSON(SeatObject seatObject) {
        Seat.Status status;
        switch (seatObject.status) {
            case 0: {
                status = Seat.Status.FREE;
                break;
            }
            case 1: {
                status = Seat.Status.RESERVED;
                break;
            }
            case 2: {
                status = Seat.Status.OCCUPIED;
                break;
            }
            default: {
                GECo4J.LOGGER.error(LogMarkers.API, "Unknown seat status: {}", (Object)seatObject.status);
                status = null;
            }
        }
        return new WebSeat(seatObject.id, seatObject.lan_user_id, seatObject.web_user_id, status, seatObject.username, seatObject.seat_number);
    }

    public static LanUser getLanUserFromJSON(GECoClient client, LanUserObject lanUserObject) {
        LanUser.Status status;
        if (lanUserObject.status_code == null) {
            status = LanUser.Status.AWAITING_REGISTRATION;
        } else {
            switch (lanUserObject.status_code) {
                case 0: {
                    status = LanUser.Status.AWAITING_PAYMENT;
                    break;
                }
                case 1: {
                    status = LanUser.Status.PAID_NO_SEAT;
                    break;
                }
                case 2: {
                    status = LanUser.Status.PAID_WITH_SEAT;
                    break;
                }
                case 3: {
                    status = LanUser.Status.CHECKED_IN;
                    break;
                }
                default: {
                    GECo4J.LOGGER.error(LogMarkers.API, "Unknown seat status: {}", (Object)lanUserObject.status);
                    status = null;
                }
            }
        }
        return new WebLanUser(client, lanUserObject.id, lanUserObject.status, status, lanUserObject.username, lanUserObject.first_name, lanUserObject.last_name, lanUserObject.seat, lanUserObject.birthday, lanUserObject.sa_verified, lanUserObject.legi_number, lanUserObject.package_name, lanUserObject.student_association);
    }

    public static BorrowedItem getBorrowedItemFromJSON(GECoClient client, BorrowedItemObject borrowedItemObject, Long userID) {
        return new WebBorrowedItem(client, borrowedItemObject.id, userID, borrowedItemObject.name);
    }

    public static News getNewsFromJSON(NewsObject newsObject) {
        return new WebNews(newsObject.title, newsObject.description, newsObject.url, newsObject.is_draft, newsObject.published_at, newsObject.author.name, newsObject.author.url, newsObject.author.icon_url, newsObject.footer.text);
    }

    public static Event getEventFromJSON(EventObject eventObject) {
        return new WebEvent(eventObject.title, eventObject.description, eventObject.url);
    }
}

