/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.impl;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.internal.Requests;
import ch.ethz.geco.g4j.internal.json.EventObject;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.NewsObject;
import ch.ethz.geco.g4j.internal.json.SeatObject;
import ch.ethz.geco.g4j.internal.json.UserObject;
import ch.ethz.geco.g4j.obj.Event;
import ch.ethz.geco.g4j.obj.GECoClient;
import ch.ethz.geco.g4j.obj.LanUser;
import ch.ethz.geco.g4j.obj.News;
import ch.ethz.geco.g4j.obj.Seat;
import ch.ethz.geco.g4j.obj.User;
import ch.ethz.geco.g4j.util.LogMarkers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultGECoClient
implements GECoClient {
    public final Requests REQUESTS = new Requests(this);
    private final String apiToken;

    public DefaultGECoClient(String apiToken) {
        GECo4J.LOGGER.info(LogMarkers.MAIN, "Creating new client with API token: " + apiToken);
        this.apiToken = apiToken;
    }

    @Override
    public String getAPIToken() {
        return this.apiToken;
    }

    @Override
    public Mono<User> getUserByID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/user/" + id, UserObject.class, null).map(GECoUtils::getUserFromJSON);
    }

    @Override
    public Mono<User> getUserByDiscordID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/user/discord/" + id, UserObject.class, null).map(GECoUtils::getUserFromJSON);
    }

    @Override
    public Flux<Seat> getSeats() {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/seats", SeatObject[].class, null).flatMapMany(seatObjects -> {
            Object[] seats = new Seat[((SeatObject[])seatObjects).length];
            for (int i = 0; i < ((SeatObject[])seatObjects).length; ++i) {
                seats[i] = GECoUtils.getSeatFromJSON(seatObjects[i]);
            }
            return Flux.fromArray((Object[])seats);
        });
    }

    @Override
    public Mono<Seat> getSeatByID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/seats/" + id, SeatObject.class, null).map(GECoUtils::getSeatFromJSON);
    }

    @Override
    public Mono<LanUser> getLanUserByID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/user/" + id, LanUserObject.class, null).map(lanUserObject -> GECoUtils.getLanUserFromJSON(this, lanUserObject));
    }

    @Override
    public Mono<LanUser> getLanUserByName(String name) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/search/user/" + name, LanUserObject.class, null).map(lanUserObject -> GECoUtils.getLanUserFromJSON(this, lanUserObject));
    }

    @Override
    public Mono<Seat> getSeatByName(String name) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/lan/search/seats/" + name, SeatObject.class, null).map(GECoUtils::getSeatFromJSON);
    }

    @Override
    public Mono<News> getNewsByID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/web/news/" + id, NewsObject.class, null).map(GECoUtils::getNewsFromJSON);
    }

    @Override
    public Flux<News> getNews(Integer page) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/web/news?page=" + page, NewsObject[].class, null).flatMapMany(newsObjects -> {
            Object[] news = new News[((NewsObject[])newsObjects).length];
            for (int i = 0; i < ((NewsObject[])newsObjects).length; ++i) {
                news[i] = GECoUtils.getNewsFromJSON(newsObjects[i]);
            }
            return Flux.fromArray((Object[])news);
        });
    }

    @Override
    public Mono<Event> getEventByID(Long id) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/web/events/" + id, EventObject.class, null).map(GECoUtils::getEventFromJSON);
    }

    @Override
    public Flux<Event> getEvents(Integer page) {
        return this.REQUESTS.makeRequest(Requests.METHOD.GET, "/web/events?page=" + page, EventObject[].class, null).flatMapMany(eventObjects -> {
            Object[] events = new Event[((EventObject[])eventObjects).length];
            for (int i = 0; i < ((EventObject[])eventObjects).length; ++i) {
                events[i] = GECoUtils.getEventFromJSON(eventObjects[i]);
            }
            return Flux.fromArray((Object[])events);
        });
    }
}

