/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.impl;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.internal.Requests;
import ch.ethz.geco.g4j.internal.json.EventObject;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.NewsObject;
import ch.ethz.geco.g4j.internal.json.SeatObject;
import ch.ethz.geco.g4j.internal.json.UserObject;
import ch.ethz.geco.g4j.obj.Event;
import ch.ethz.geco.g4j.obj.GECoClient;
import ch.ethz.geco.g4j.obj.LanUser;
import ch.ethz.geco.g4j.obj.News;
import ch.ethz.geco.g4j.obj.Seat;
import ch.ethz.geco.g4j.obj.User;
import ch.ethz.geco.g4j.util.APIException;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.message.BasicNameValuePair;

public class DefaultGECoClient
implements GECoClient {
    public final Requests REQUESTS = new Requests(this);
    private final String apiToken;

    public DefaultGECoClient(String apiToken) {
        GECo4J.LOGGER.info(LogMarkers.MAIN, "Creating new client with API token: " + apiToken);
        this.apiToken = apiToken;
    }

    @Override
    public String getAPIToken() {
        return this.apiToken;
    }

    @Override
    public User getUserByID(Long id) {
        try {
            UserObject userObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/user/" + id, UserObject.class, new BasicNameValuePair[0]);
            if (userObject == null) {
                return null;
            }
            return GECoUtils.getUserFromJSON(userObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public User getUserByDiscordID(Long id) {
        try {
            UserObject userObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/user/discord/" + id, UserObject.class, new BasicNameValuePair[0]);
            if (userObject == null) {
                return null;
            }
            return GECoUtils.getUserFromJSON(userObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public List<Seat> getSeats() {
        try {
            List seatObjects = (List)this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/seats", (TypeReference)new TypeReference<List<SeatObject>>(){}, new BasicNameValuePair[0]);
            if (seatObjects == null) {
                return null;
            }
            ArrayList<Seat> seats = new ArrayList<Seat>();
            seatObjects.forEach(seatObject -> seats.add(GECoUtils.getSeatFromJSON(seatObject)));
            return seats;
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return new ArrayList<Seat>();
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public Seat getSeatByID(Long id) {
        try {
            SeatObject seatObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/seats/" + id, SeatObject.class, new BasicNameValuePair[0]);
            if (seatObject == null) {
                return null;
            }
            return GECoUtils.getSeatFromJSON(seatObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public LanUser getLanUserByID(Long id) {
        try {
            LanUserObject lanUserObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/user/" + id, LanUserObject.class, new BasicNameValuePair[0]);
            if (lanUserObject == null) {
                return null;
            }
            return GECoUtils.getLanUserFromJSON(this, lanUserObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public LanUser getLanUserByName(String name) {
        try {
            LanUserObject lanUserObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/search/user/" + name, LanUserObject.class, new BasicNameValuePair[0]);
            if (lanUserObject == null) {
                return null;
            }
            return GECoUtils.getLanUserFromJSON(this, lanUserObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public Seat getSeatByName(String name) {
        try {
            SeatObject seatObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/search/seats/" + name, SeatObject.class, new BasicNameValuePair[0]);
            if (seatObject == null) {
                return null;
            }
            return GECoUtils.getSeatFromJSON(seatObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public News getNewsByID(Long id) {
        try {
            NewsObject newsObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/web/news/" + id, NewsObject.class, new BasicNameValuePair[0]);
            if (newsObject == null) {
                return null;
            }
            return GECoUtils.getNewsFromJSON(newsObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public List<News> getNews(Integer page) {
        try {
            List newsObjects = (List)this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/web/news?page=" + page, (TypeReference)new TypeReference<List<NewsObject>>(){}, new BasicNameValuePair[0]);
            if (newsObjects == null) {
                return null;
            }
            ArrayList<News> news = new ArrayList<News>();
            newsObjects.forEach(newsObject -> news.add(GECoUtils.getNewsFromJSON(newsObject)));
            return news;
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return new ArrayList<News>();
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public Event getEventByID(Long id) {
        try {
            EventObject eventObject = this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/web/events/" + id, EventObject.class, new BasicNameValuePair[0]);
            if (eventObject == null) {
                return null;
            }
            return GECoUtils.getEventFromJSON(eventObject);
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return null;
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }

    @Override
    public List<Event> getEvents(Integer page) {
        try {
            List eventObjects = (List)this.REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/web/events?page=" + page, (TypeReference)new TypeReference<List<EventObject>>(){}, new BasicNameValuePair[0]);
            if (eventObjects == null) {
                return null;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            eventObjects.forEach(eventObject -> events.add(GECoUtils.getEventFromJSON(eventObject)));
            return events;
        }
        catch (APIException e) {
            if (e.getError() == APIException.Error.NOT_FOUND) {
                return new ArrayList<Event>();
            }
            GECo4J.LOGGER.error(LogMarkers.UTIL, "Unknown error occured! Please contact a developer.");
            return null;
        }
    }
}

