/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.impl;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.impl.GECoClient;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.internal.json.BorrowItemRequest;
import ch.ethz.geco.g4j.internal.json.BorrowedItemObject;
import ch.ethz.geco.g4j.internal.json.CheckinRequest;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.VerifyRequest;
import ch.ethz.geco.g4j.obj.IBorrowedItem;
import ch.ethz.geco.g4j.obj.IGECoClient;
import ch.ethz.geco.g4j.obj.ILanUser;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.message.BasicNameValuePair;

public class LanUser
implements ILanUser {
    private final IGECoClient client;
    private final Long id;
    private final String statusMessage;
    private final ILanUser.Status status;
    private final String username;
    private final String firstName;
    private final String lastName;
    private final String seatName;
    private final Long birthday;
    private final Boolean isVerified;
    private final String legiNumber;
    private final String lanPackage;
    private final String studentAssoc;

    public LanUser(IGECoClient client, Long id, String statusMessage, ILanUser.Status status, String username, String firstName, String lastName, String seatName, Long birthday, Boolean isVerified, String legiNumber, String lanPackage, String studentAssoc) {
        this.client = client;
        this.id = id;
        this.statusMessage = statusMessage;
        this.status = status;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.seatName = seatName;
        this.birthday = birthday;
        this.isVerified = isVerified;
        this.legiNumber = legiNumber;
        this.lanPackage = lanPackage;
        this.studentAssoc = studentAssoc;
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public ILanUser.Status getStatus() {
        return this.status;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getSeatName() {
        return this.seatName;
    }

    @Override
    public Long getBirthDay() {
        return this.birthday;
    }

    @Override
    public Boolean isVerified() {
        return this.isVerified;
    }

    @Override
    public Optional<String> getLegiNumber() {
        return Optional.ofNullable(this.legiNumber);
    }

    @Override
    public String getLANPackage() {
        return this.lanPackage;
    }

    @Override
    public String getStudentAssoc() {
        return this.studentAssoc;
    }

    @Override
    public Boolean setVerification(Boolean isVerified, String legiNumber) {
        try {
            LanUserObject lanUserObject = ((GECoClient)this.client).REQUESTS.PATCH.makeRequest("https://geco.ethz.ch/api/v2/lan/user/" + this.id + "/verify", GECoUtils.MAPPER.writeValueAsString((Object)new VerifyRequest(isVerified, legiNumber)), LanUserObject.class, new BasicNameValuePair[0]);
            if (lanUserObject == null) {
                GECo4J.LOGGER.error(LogMarkers.API, "Internal Error! Please contact a developer.");
                return null;
            }
            return lanUserObject.sa_verified == isVerified && lanUserObject.legi_number.equals(legiNumber);
        }
        catch (JsonProcessingException e) {
            GECo4J.LOGGER.error(LogMarkers.MAIN, "Internal Error! Please contact a developer.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean checkin(String checkinString) {
        try {
            LanUserObject lanUserObject = ((GECoClient)this.client).REQUESTS.PATCH.makeRequest("https://geco.ethz.ch/api/v2/lan/user/" + this.id + "/checkin", GECoUtils.MAPPER.writeValueAsString((Object)new CheckinRequest(checkinString)), LanUserObject.class, new BasicNameValuePair[0]);
            if (lanUserObject == null) {
                GECo4J.LOGGER.error(LogMarkers.API, "Internal Error! Please contact a developer.");
                return null;
            }
            return lanUserObject.status_code == 3;
        }
        catch (JsonProcessingException e) {
            GECo4J.LOGGER.error(LogMarkers.MAIN, "Internal Error! Please contact a developer.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<IBorrowedItem> getBorrowedItems() {
        List borrowedItemObjects = (List)((GECoClient)this.client).REQUESTS.GET.makeRequest("https://geco.ethz.ch/api/v2/lan/user" + this.id + "/items", (TypeReference)new TypeReference<List<BorrowedItemObject>>(){}, new BasicNameValuePair[0]);
        if (borrowedItemObjects == null) {
            GECo4J.LOGGER.error(LogMarkers.API, "Internal Error! Please contact a developer.");
            return null;
        }
        ArrayList<IBorrowedItem> borrowedItems = new ArrayList<IBorrowedItem>();
        borrowedItemObjects.forEach(borrowedItemObject -> borrowedItems.add(GECoUtils.getBorrowedItemFromJSON(this.client, borrowedItemObject, this.id)));
        return borrowedItems;
    }

    @Override
    public IBorrowedItem borrowItem(String name) {
        try {
            BorrowedItemObject borrowedItemObject = ((GECoClient)this.client).REQUESTS.POST.makeRequest("https://geco.ethz.ch/api/v2/lan/user/" + this.id + "/items", GECoUtils.MAPPER.writeValueAsString((Object)new BorrowItemRequest(name)), BorrowedItemObject.class, new BasicNameValuePair[0]);
            if (borrowedItemObject == null) {
                GECo4J.LOGGER.error(LogMarkers.API, "Internal Error! Please contact a developer.");
                return null;
            }
            return GECoUtils.getBorrowedItemFromJSON(this.client, borrowedItemObject, this.id);
        }
        catch (JsonProcessingException e) {
            GECo4J.LOGGER.error(LogMarkers.MAIN, "Internal Error! Please contact a developer.");
            e.printStackTrace();
            return null;
        }
    }
}

