/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.internal;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.internal.GECoUtils;
import ch.ethz.geco.g4j.obj.IGECoClient;
import ch.ethz.geco.g4j.util.APIException;
import ch.ethz.geco.g4j.util.GECoException;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Requests {
    public final Request POST;
    public final Request GET;
    public final Request DELETE;
    public final Request PATCH;
    public final Request PUT;
    private final CloseableHttpClient httpClient = HttpClients.createDefault();

    public Requests(IGECoClient client) {
        this.POST = new Request(HttpPost.class, client);
        this.GET = new Request(HttpGet.class, client);
        this.DELETE = new Request(HttpDelete.class, client);
        this.PATCH = new Request(HttpPatch.class, client);
        this.PUT = new Request(HttpPut.class, client);
    }

    public final class Request {
        private final Class<? extends HttpUriRequest> requestClass;
        private final IGECoClient client;

        private Request(Class<? extends HttpUriRequest> requestClass, IGECoClient client) {
            this.requestClass = requestClass;
            this.client = client;
        }

        public <T> T makeRequest(String url, Object entity, Class<T> clazz, BasicNameValuePair ... headers) {
            try {
                return this.makeRequest(url, GECoUtils.MAPPER.writeValueAsString(entity), clazz, headers);
            }
            catch (JsonProcessingException e) {
                throw new GECoException("Unable to serialize request!", e);
            }
        }

        public <T> T makeRequest(String url, String entity, Class<T> clazz, BasicNameValuePair ... headers) {
            try {
                String response = this.makeRequest(url, entity, headers);
                return (T)(response == null ? null : GECoUtils.MAPPER.readValue(response, clazz));
            }
            catch (IOException e) {
                throw new GECoException("Unable to serialize request!", e);
            }
        }

        public <T> T makeRequest(String url, Class<T> clazz, BasicNameValuePair ... headers) {
            try {
                String response = this.makeRequest(url, headers);
                return (T)(response == null ? null : GECoUtils.MAPPER.readValue(response, clazz));
            }
            catch (IOException e) {
                throw new GECoException("Unable to serialize request!", e);
            }
        }

        public <T> T makeRequest(String url, TypeReference typeReference, BasicNameValuePair ... headers) {
            try {
                String response = this.makeRequest(url, headers);
                return (T)(response == null ? null : GECoUtils.MAPPER.readValue(response, typeReference));
            }
            catch (IOException e) {
                throw new GECoException("Unable to serialize request!", e);
            }
        }

        public void makeRequest(String url, Object entity, BasicNameValuePair ... headers) {
            try {
                this.makeRequest(url, GECoUtils.MAPPER.writeValueAsString(entity), headers);
            }
            catch (IOException e) {
                throw new GECoException("Unable to serialize request!", e);
            }
        }

        public String makeRequest(String url, String entity, BasicNameValuePair ... headers) {
            return this.makeRequest(url, (HttpEntity)new StringEntity(entity, "UTF-8"), headers);
        }

        public String makeRequest(String url, BasicNameValuePair ... headers) {
            try {
                HttpUriRequest request = this.requestClass.getConstructor(String.class).newInstance(url);
                for (BasicNameValuePair header : headers) {
                    request.addHeader(header.getName(), header.getValue());
                }
                return this.request(request);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                GECo4J.LOGGER.error(LogMarkers.API, "GECo4J Internal Exception", (Throwable)e);
                return null;
            }
        }

        public String makeRequest(String url, HttpEntity entity, BasicNameValuePair ... headers) {
            try {
                if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(this.requestClass)) {
                    HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)this.requestClass.getConstructor(String.class).newInstance(url);
                    for (BasicNameValuePair header : headers) {
                        request.addHeader(header.getName(), header.getValue());
                    }
                    request.setEntity(entity);
                    return this.request((HttpUriRequest)request);
                }
                GECo4J.LOGGER.error(LogMarkers.API, "Tried to attach HTTP entity to invalid type! ({})", (Object)this.requestClass.getSimpleName());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                GECo4J.LOGGER.error(LogMarkers.API, "GECo4J Internal Exception", (Throwable)e);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String request(HttpUriRequest request) {
            if (this.client != null) {
                request.addHeader("X-API-KEY", this.client.getAPIToken());
            }
            try (CloseableHttpResponse response = Requests.this.httpClient.execute(request);){
                int responseCode = response.getStatusLine().getStatusCode();
                String data = null;
                if (response.getEntity() != null) {
                    data = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                if (responseCode == 403) throw (APIException)GECoUtils.MAPPER.readValue(data, APIException.class);
                if (responseCode == 404) throw (APIException)GECoUtils.MAPPER.readValue(data, APIException.class);
                if (responseCode == 424) {
                    throw (APIException)GECoUtils.MAPPER.readValue(data, APIException.class);
                }
                if (responseCode < 200) throw new GECoException("Error on request to " + request.getURI() + ". Received response code " + responseCode + ". With response text: " + data);
                if (responseCode > 299) {
                    throw new GECoException("Error on request to " + request.getURI() + ". Received response code " + responseCode + ". With response text: " + data);
                }
                String string = data;
                return string;
            }
            catch (IOException e) {
                GECo4J.LOGGER.error(LogMarkers.API, "GECo4J Internal Exception", (Throwable)e);
                return null;
            }
        }
    }
}

