/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.geco.g4j.internal;

import ch.ethz.geco.g4j.GECo4J;
import ch.ethz.geco.g4j.impl.BorrowedItem;
import ch.ethz.geco.g4j.impl.Event;
import ch.ethz.geco.g4j.impl.LanUser;
import ch.ethz.geco.g4j.impl.News;
import ch.ethz.geco.g4j.impl.Seat;
import ch.ethz.geco.g4j.impl.User;
import ch.ethz.geco.g4j.internal.json.BorrowedItemObject;
import ch.ethz.geco.g4j.internal.json.EventObject;
import ch.ethz.geco.g4j.internal.json.LanUserObject;
import ch.ethz.geco.g4j.internal.json.NewsObject;
import ch.ethz.geco.g4j.internal.json.SeatObject;
import ch.ethz.geco.g4j.internal.json.UserObject;
import ch.ethz.geco.g4j.obj.IBorrowedItem;
import ch.ethz.geco.g4j.obj.IEvent;
import ch.ethz.geco.g4j.obj.IGECoClient;
import ch.ethz.geco.g4j.obj.ILanUser;
import ch.ethz.geco.g4j.obj.INews;
import ch.ethz.geco.g4j.obj.ISeat;
import ch.ethz.geco.g4j.obj.IUser;
import ch.ethz.geco.g4j.util.LogMarkers;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import org.jetbrains.annotations.NotNull;

public class GECoUtils {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static IUser getUserFromJSON(@NotNull UserObject userObject) {
        if (userObject == null) {
            GECoUtils.$$$reportNull$$$0(0);
        }
        return new User(userObject.id, userObject.name, userObject.usergroup, userObject.lol, userObject.steam, userObject.bnet, userObject.discord);
    }

    public static ISeat getSeatFromJSON(@NotNull SeatObject seatObject) {
        ISeat.Status status;
        if (seatObject == null) {
            GECoUtils.$$$reportNull$$$0(1);
        }
        switch (seatObject.status) {
            case 0: {
                status = ISeat.Status.FREE;
                break;
            }
            case 1: {
                status = ISeat.Status.RESERVED;
                break;
            }
            case 2: {
                status = ISeat.Status.OCCUPIED;
                break;
            }
            default: {
                GECo4J.LOGGER.error(LogMarkers.API, "Unknown seat status: {}", (Object)seatObject.status);
                status = null;
            }
        }
        return new Seat(seatObject.id, seatObject.lan_user_id, seatObject.web_user_id, status, seatObject.username, seatObject.seat_number);
    }

    public static ILanUser getLanUserFromJSON(@NotNull IGECoClient client, @NotNull LanUserObject lanUserObject) {
        ILanUser.Status status;
        if (client == null) {
            GECoUtils.$$$reportNull$$$0(2);
        }
        if (lanUserObject == null) {
            GECoUtils.$$$reportNull$$$0(3);
        }
        switch (lanUserObject.status_code) {
            case 0: {
                status = ILanUser.Status.AWAITING_PAYMENT;
                break;
            }
            case 1: {
                status = ILanUser.Status.PAID_NO_SEAT;
                break;
            }
            case 2: {
                status = ILanUser.Status.PAID_WITH_SEAT;
                break;
            }
            case 3: {
                status = ILanUser.Status.CHECKED_IN;
            }
            default: {
                GECo4J.LOGGER.error(LogMarkers.API, "Unknown seat status: {}", (Object)lanUserObject.status);
                status = null;
            }
        }
        return new LanUser(client, lanUserObject.id, lanUserObject.status, status, lanUserObject.username, lanUserObject.first_name, lanUserObject.last_name, lanUserObject.seat, lanUserObject.birthday, lanUserObject.sa_verified, lanUserObject.legi_number, lanUserObject.package_name, lanUserObject.student_association);
    }

    public static IBorrowedItem getBorrowedItemFromJSON(@NotNull IGECoClient client, @NotNull BorrowedItemObject borrowedItemObject, @NotNull Long userID) {
        if (client == null) {
            GECoUtils.$$$reportNull$$$0(4);
        }
        if (borrowedItemObject == null) {
            GECoUtils.$$$reportNull$$$0(5);
        }
        if (userID == null) {
            GECoUtils.$$$reportNull$$$0(6);
        }
        return new BorrowedItem(client, borrowedItemObject.id, userID, borrowedItemObject.name);
    }

    public static INews getNewsFromJSON(@NotNull NewsObject newsObject) {
        if (newsObject == null) {
            GECoUtils.$$$reportNull$$$0(7);
        }
        return new News(newsObject.title, newsObject.description, newsObject.url, newsObject.is_draft, newsObject.author.name, newsObject.author.url, newsObject.author.icon_url, newsObject.footer.text);
    }

    public static IEvent getEventFromJSON(@NotNull EventObject eventObject) {
        if (eventObject == null) {
            GECoUtils.$$$reportNull$$$0(8);
        }
        return new Event(eventObject.title, eventObject.description, eventObject.url);
    }

    static {
        MAPPER.registerModule((Module)new AfterburnerModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seatObject";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lanUserObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borrowedItemObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userID";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newsObject";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventObject";
                break;
            }
        }
        objectArray2[1] = "ch/ethz/geco/g4j/internal/GECoUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserFromJSON";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSeatFromJSON";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanUserFromJSON";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBorrowedItemFromJSON";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewsFromJSON";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventFromJSON";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

