package ch.epfl.scala.bsp4j;

import ch.epfl.scala.bsp4j.StatusCode;
import com.google.gson.annotations.JsonAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class CompileResult {
  private String originId;
  
  @JsonAdapter(JsonElementTypeAdapter.Factory.class)
  private Object data;
  
  @NonNull
  private StatusCode statusCode;
  
  public CompileResult(@NonNull final StatusCode statusCode) {
    this.statusCode = statusCode;
  }
  
  @Pure
  public String getOriginId() {
    return this.originId;
  }
  
  public void setOriginId(final String originId) {
    this.originId = originId;
  }
  
  @Pure
  public Object getData() {
    return this.data;
  }
  
  public void setData(final Object data) {
    this.data = data;
  }
  
  @Pure
  @NonNull
  public StatusCode getStatusCode() {
    return this.statusCode;
  }
  
  public void setStatusCode(@NonNull final StatusCode statusCode) {
    this.statusCode = statusCode;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("originId", this.originId);
    b.add("data", this.data);
    b.add("statusCode", this.statusCode);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    CompileResult other = (CompileResult) obj;
    if (this.originId == null) {
      if (other.originId != null)
        return false;
    } else if (!this.originId.equals(other.originId))
      return false;
    if (this.data == null) {
      if (other.data != null)
        return false;
    } else if (!this.data.equals(other.data))
      return false;
    if (this.statusCode == null) {
      if (other.statusCode != null)
        return false;
    } else if (!this.statusCode.equals(other.statusCode))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.originId== null) ? 0 : this.originId.hashCode());
    result = prime * result + ((this.data== null) ? 0 : this.data.hashCode());
    return prime * result + ((this.statusCode== null) ? 0 : this.statusCode.hashCode());
  }
}
