/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.leb.defcon.ij.gui;

import ch.epfl.leb.defcon.ij.DensityCount;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class RunDensityCount
implements PlugIn {
    private static final String PATHKEY = "defcon.model.density";
    private static final String DEFAULTPATH = "/path/to/tf_density_count";

    public void run(String arg) {
        GenericDialog gd = new GenericDialog("DEFCoN Setup: Density Count");
        gd.addMessage("Please specify the path to the saved DEFCoN density map model.");
        String pathPref = Prefs.get((String)PATHKEY, (String)DEFAULTPATH);
        gd.addStringField("path", pathPref, 64);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String path = gd.getNextString();
        Prefs.set((String)PATHKEY, (String)path);
        ImagePlus imp = IJ.getImage();
        DensityCount dc = new DensityCount();
        dc.setup(path, imp);
        ImageProcessor ip = imp.getProcessor();
        dc.run(ip);
    }
}

