/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.leb.defcon.ij;

import ch.epfl.leb.defcon.predictors.ImageBitDepthException;
import ch.epfl.leb.defcon.predictors.Predictor;
import ch.epfl.leb.defcon.predictors.SessionClosedException;
import ch.epfl.leb.defcon.predictors.UninitializedPredictorException;
import ch.epfl.leb.defcon.predictors.internal.DefaultPredictor;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class DensityCount
implements PlugInFilter {
    private ImagePlus image;
    private ResultsTable rt;
    private Predictor predictor = new DefaultPredictor();
    private Roi roi;
    private ImageStack densityStack;

    public void run(ImageProcessor ip) {
        int stackSize = this.image.getImageStackSize();
        this.roi = WindowManager.getCurrentImage().getRoi();
        Roi reshapedRoi = this.initRoiAndStack();
        for (int i = 1; i <= stackSize; ++i) {
            double count;
            ImageProcessor proc = this.image.getImageStack().getProcessor(i);
            ImagePlus slice = new ImagePlus("DEFCoN", proc);
            slice.setRoi(reshapedRoi);
            this.rt.incrementCounter();
            try {
                this.predictor.predict(slice.crop().getProcessor());
                this.densityStack.addSlice((ImageProcessor)this.predictor.getDensityMap());
                count = this.predictor.getCount();
            }
            catch (ImageBitDepthException | SessionClosedException | UninitializedPredictorException ex) {
                IJ.log((String)ex.getMessage());
                this.predictor.close();
                return;
            }
            this.rt.addValue("Rounded count", (double)Math.round(count));
            this.rt.addValue("Exact count", count);
            IJ.showProgress((int)i, (int)stackSize);
        }
        this.predictor.close();
        ImagePlus densityImage = new ImagePlus("Density map", this.densityStack);
        IJ.run((ImagePlus)densityImage, (String)"mpl-viridis", (String)"");
        densityImage.show();
        this.rt.show("Fluorophore count");
    }

    public int setup(String pathToModel, ImagePlus imp) {
        if (imp.isLocked()) {
            imp.unlock();
        }
        this.image = imp;
        this.predictor.setup(pathToModel);
        this.rt = new ResultsTable();
        return 5;
    }

    private Roi initRoiAndStack() {
        int image_width = this.image.getWidth();
        int image_height = this.image.getHeight();
        if (this.roi == null) {
            this.roi = new Roi(0, 0, image_width, image_height);
        }
        Roi reshapedRoi = new Roi(this.roi.getBounds().x, this.roi.getBounds().y, this.roi.getBounds().width - this.roi.getBounds().width % 4, this.roi.getBounds().height - this.roi.getBounds().height % 4);
        WindowManager.getCurrentImage().setRoi(reshapedRoi);
        this.densityStack = new ImageStack(reshapedRoi.getBounds().width, reshapedRoi.getBounds().height);
        return reshapedRoi;
    }
}

