/*
 * Decompiled with CFR 0.152.
 */
package inox.solvers;

import inox.Context;
import inox.Model;
import inox.OptionValue;
import inox.Options;
import inox.Program;
import inox.Reporter;
import inox.TestContext$;
import inox.ast.Expressions;
import inox.ast.Trees;
import inox.ast.Types;
import inox.package;
import inox.package$;
import inox.solvers.SimpleSolverAPI$;
import inox.solvers.SolverFactory;
import inox.solvers.SolverFactory$;
import inox.solvers.SolverResponses;
import inox.solvers.optCheckModels$;
import inox.utils.InterruptManager;
import inox.utils.TimerStorage;
import java.io.Serializable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\b\u0011\u0001UAQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\r1\u0005\u0003\u0004)\u0001\u0001\u0006I\u0001\n\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\u0011\u0004\u0001)A\u0005W!91\u0007\u0001b\u0001\n\u0003!\u0004B\u0002&\u0001A\u0003%Q\u0007C\u0004L\u0001\t\u0007I\u0011\u0001'\t\r\u0019\u0004\u0001\u0015!\u0003N\u0011\u001d9\u0007A1A\u0005\u0002!Daa\u001c\u0001!\u0002\u0013I\u0007b\u00029\u0001\u0005\u0004%\t!\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\t\u000b]\u0004A\u0011\u0001=\u0003\u0019M{GN^3sgN+\u0018\u000e^3\u000b\u0005E\u0011\u0012aB:pYZ,'o\u001d\u0006\u0002'\u0005!\u0011N\\8y\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012!C:dC2\fG/Z:u\u0015\u0005Y\u0012aA8sO&\u0011Q\u0004\u0007\u0002\t\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011\u0001E\u0001\u0004GRDX#\u0001\u0013\u0011\u0005\u00152S\"\u0001\n\n\u0005\u001d\u0012\"aB\"p]R,\u0007\u0010^\u0001\u0005GRD\b%A\u0001q+\u0005Y\u0003C\u0001\u00170\u001d\t)S&\u0003\u0002/%\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00192\u0005-Ien\u001c=Qe><'/Y7\u000b\u00059\u0012\u0012A\u00019!\u0003-\u0019x\u000e\u001c<fe:\u000bW.Z:\u0016\u0003U\u00022AN C\u001d\t9TH\u0004\u00029w5\t\u0011H\u0003\u0002;)\u00051AH]8pizJ\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003]yR\u0011\u0001P\u0005\u0003\u0001\u0006\u00131aU3r\u0015\tqc\b\u0005\u0002D\u000f:\u0011A)\u0012\t\u0003qyJ!A\u0012 \u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rz\nAb]8mm\u0016\u0014h*Y7fg\u0002\nQ\u0001^=qKN,\u0012!\u0014\t\u0004\u001dF\u0013V\"A(\u000b\u0005As\u0014AC2pY2,7\r^5p]&\u0011\u0001i\u0014\n\u0004'V\u0013g\u0001\u0002+\u0001\u0001I\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"A\u0016/\u000f\u0005]SfB\u0001-.\u001d\tA\u0014,C\u0001\u0014\u0013\tY\u0016'A\u0003ue\u0016,7/\u0003\u0002^=\n!A+\u001f9f\u0013\ty\u0006MA\u0003UsB,7O\u0003\u0002b%\u0005\u0019\u0011m\u001d;\u0011\u0005\r$W\"\u0001 \n\u0005\u0015t$a\u0002)s_\u0012,8\r^\u0001\u0007if\u0004Xm\u001d\u0011\u0002\u0005Y\u001cX#A5\u0011\u00079\u000b&\u000e\u0005\u0002WW&\u0011A.\u001c\u0002\t-\u0006\u0014\u0018.\u00192mK&\u0011a\u000e\u0019\u0002\f\u000bb\u0004(/Z:tS>t7/A\u0002wg\u0002\naa\u00198tiJ\u001cX#\u0001:\u0011\u00079\u000b6\u000f\u0005\u0002Wi&\u0011Q/\u001c\u0002\u0005\u000bb\u0004(/A\u0004d]N$(o\u001d\u0011\u0002\u0017\rDWmY6T_24XM\u001d\u000b\u0007sr\f\t\"!\u0007\u0011\u0005\rT\u0018BA>?\u0005\u0011)f.\u001b;\t\u000but\u0001\u0019\u0001@\u0002\u0005M4'cA@\u0002\u0002\u0019!A\u000b\u0001\u0001\u007f!\r\t\u00131A\u0005\u0004\u0003\u000b\u0001\"!D*pYZ,'OR1di>\u0014\u0018\u0010C\u0005\u0002\n}\u0014\rQ\"\u0011\u0002\f\u00059\u0001O]8he\u0006lWCAA\u0007\u001d\r\ty\u0001B\u0007\u0002\u0001!1qM\u0004a\u0001\u0003'\u0001BaQA\u000bU&\u0019\u0011qC%\u0003\u0007M+G\u000f\u0003\u0004\u0002\u001c9\u0001\ra]\u0001\u0006G:\u001cHO\u001d")
public class SolversSuite
extends FunSuite {
    private final Context ctx;
    private final Program p;
    private final Seq<String> solverNames;
    private final Seq<Types.Type> types;
    private final Seq<Expressions.Variable> vs;
    private final Seq<Expressions.Expr> cnstrs;

    public Context ctx() {
        return this.ctx;
    }

    public Program p() {
        return this.p;
    }

    public Seq<String> solverNames() {
        return this.solverNames;
    }

    public Seq<Types.Type> types() {
        return this.types;
    }

    public Seq<Expressions.Variable> vs() {
        return this.vs;
    }

    public Seq<Expressions.Expr> cnstrs() {
        return this.cnstrs;
    }

    public void checkSolver(SolverFactory sf, Set<Expressions.Variable> vs, Expressions.Expr cnstr) {
        SolverResponses.ResponseWithModel responseWithModel = SimpleSolverAPI$.MODULE$.apply(sf).solveSAT(cnstr);
        if (!(responseWithModel instanceof SolverResponses.SatWithModel)) {
            throw this.fail(new StringBuilder(32).append("Solver ").append(sf.name()).append(" - Constraint ").append(cnstr.asString(this.p().printerOpts(this.ctx()))).append(" is unsat!?").toString(), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }
        SolverResponses.SatWithModel satWithModel = (SolverResponses.SatWithModel)responseWithModel;
        Model model = (Model)satWithModel.model();
        vs.foreach((Function1 & Serializable & scala.Serializable)v -> {
            Option option = model.vars().get((Object)v.toVal());
            if (!(option instanceof Some)) {
                throw this.fail(new StringBuilder(42).append("Solver ").append(sf.name()).append(" - Model does not contain ").append(v.id().uniqueName()).append(" of type ").append(v.getType(this.p().symbols().implicitSymbols())).toString(), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            }
            Some some = (Some)option;
            Expressions.Expr e = (Expressions.Expr)some.value();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getType(this.p().symbols().implicitSymbols()));
            Types.Type $org_scalatest_assert_macro_right = v.getType(this.p().symbols().implicitSymbols());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(35).append("Solver ").append(sf.name()).append(" - Extracting value of type ").append(v.getType(this.p().symbols().implicitSymbols())).toString(), Prettifier$.MODULE$.default(), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            return assertion;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SolversSuite() {
        Context qual$1 = TestContext$.MODULE$.empty();
        Options x$1 = new Options((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionValue[]{optCheckModels$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))})));
        Reporter x$2 = qual$1.copy$default$1();
        InterruptManager x$3 = qual$1.copy$default$2();
        TimerStorage x$4 = qual$1.copy$default$4();
        this.ctx = qual$1.copy(x$2, x$3, x$1, x$4);
        this.p = package.InoxProgram$.MODULE$.apply((package.trees.Symbols)package.trees$.MODULE$.NoSymbols());
        this.solverNames = (Seq)((TraversableLike)((TraversableLike)(SolverFactory$.MODULE$.hasNativeZ3() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nativez3"})) : Nil$.MODULE$)).$plus$plus((GenTraversableOnce)(SolverFactory$.MODULE$.hasZ3() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smt-z3"})) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(SolverFactory$.MODULE$.hasCVC4() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smt-cvc4"})) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        this.types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.Type[]{new Types.BooleanType((Trees)package.trees$.MODULE$), new Types.UnitType((Trees)package.trees$.MODULE$), new Types.CharType((Trees)package.trees$.MODULE$), new Types.RealType((Trees)package.trees$.MODULE$), new Types.IntegerType((Trees)package.trees$.MODULE$), package.trees$.MODULE$.Int8Type().apply(), new Types.BVType((Trees)package.trees$.MODULE$, true, 13), package.trees$.MODULE$.Int16Type().apply(), package.trees$.MODULE$.Int32Type().apply(), new Types.BVType((Trees)package.trees$.MODULE$, true, 33), package.trees$.MODULE$.Int64Type().apply(), new Types.StringType((Trees)package.trees$.MODULE$), package.trees$.MODULE$.TypeParameter().fresh("T", package.trees$.MODULE$.TypeParameter().fresh$default$2()), new Types.SetType((Trees)package.trees$.MODULE$, (Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$)), new Types.BagType((Trees)package.trees$.MODULE$, (Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$)), new Types.MapType((Trees)package.trees$.MODULE$, (Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$), (Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$)), new Types.FunctionType((Trees)package.trees$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.IntegerType[]{new Types.IntegerType((Trees)package.trees$.MODULE$)})), (Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$)), new Types.TupleType((Trees)package.trees$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.Type[]{new Types.IntegerType((Trees)package.trees$.MODULE$), new Types.BooleanType((Trees)package.trees$.MODULE$), package.trees$.MODULE$.Int32Type().apply()})))}));
        this.vs = (Seq)this.types().map((Function1 & Serializable & scala.Serializable)tpe -> package.trees$.MODULE$.Variable().fresh("v", tpe, true), Seq$.MODULE$.canBuildFrom());
        this.cnstrs = (Seq)this.vs().map((Function1 & Serializable & scala.Serializable)v -> {
            Expressions.Equals equals;
            Types.Type type = v.getType(this.p().symbols().implicitSymbols());
            if (type instanceof Types.UnitType) {
                equals = new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(v.getType(this.p().symbols().implicitSymbols()), this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx()));
            } else if (type instanceof Types.SetType) {
                Types.SetType setType = (Types.SetType)type;
                Types.Type base = setType.base();
                equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.ElementOfSet((Trees)package.trees$.MODULE$, this.p().symbols().simplestValue(base, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx()), (Expressions.Expr)v));
            } else if (type instanceof Types.BagType) {
                Types.BagType bagType = (Types.BagType)type;
                Types.Type base = bagType.base();
                equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.MultiplicityInBag((Trees)package.trees$.MODULE$, this.p().symbols().simplestValue(base, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx()), (Expressions.Expr)v), this.p().symbols().simplestValue((Types.Type)new Types.IntegerType((Trees)package.trees$.MODULE$), this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx())));
            } else if (type instanceof Types.MapType) {
                Types.MapType mapType = (Types.MapType)type;
                Types.Type from = mapType.from();
                Types.Type to = mapType.to();
                equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.MapApply((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(from, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx())), this.p().symbols().simplestValue(to, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx())));
            } else if (type instanceof Types.FunctionType) {
                Types.FunctionType functionType = (Types.FunctionType)type;
                Seq froms = functionType.from();
                Types.Type to = functionType.to();
                equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Application((Trees)package.trees$.MODULE$, (Expressions.Expr)v, (Seq)froms.map((Function1 & Serializable & scala.Serializable)x$1 -> this.p().symbols().simplestValue(x$1, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx()), Seq$.MODULE$.canBuildFrom())), this.p().symbols().simplestValue(to, this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx())));
            } else {
                equals = package.trees$.MODULE$.not((Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(v.getType(this.p().symbols().implicitSymbols()), this.p().symbols().simplestValue$default$2(), this.p().getSemantics(package$.MODULE$.inoxSemantics()), this.ctx())));
            }
            return equals;
        }, Seq$.MODULE$.canBuildFrom());
        this.solverNames().foreach((Function1 & Serializable & scala.Serializable)sname -> {
            this.test(new StringBuilder(20).append("Model Extraction in ").append(sname).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SolverFactory sf = SolverFactory$.MODULE$.apply(sname, $this.p(), $this.ctx(), SolverFactory$.MODULE$.apply$default$4());
                $this.checkSolver(sf, (Set<Expressions.Variable>)$this.vs().toSet(), package.trees$.MODULE$.andJoin($this.cnstrs()));
            }, new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            return BoxedUnit.UNIT;
        });
    }
}

