/*
 * Decompiled with CFR 0.152.
 */
package inox.solvers;

import inox.Context;
import inox.Program;
import inox.TestContext$;
import inox.ast.Expressions;
import inox.ast.Trees;
import inox.ast.Types;
import inox.package;
import inox.solvers.SimpleSolverAPI$;
import inox.solvers.SolverFactory;
import inox.solvers.SolverFactory$;
import inox.solvers.SolverResponses;
import java.io.Serializable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001\u001d\u0011AbU8mm\u0016\u00148oU;ji\u0016T!a\u0001\u0003\u0002\u000fM|GN^3sg*\tQ!\u0001\u0003j]>D8\u0001A\n\u0003\u0001!\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0007\u0002\u0007=\u0014x-\u0003\u0002\u0010\u0015\tAa)\u001e8Tk&$X\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!9a\u0003\u0001b\u0001\n\u00039\u0012aA2uqV\t\u0001\u0004\u0005\u0002\u001a55\tA!\u0003\u0002\u001c\t\t91i\u001c8uKb$\bBB\u000f\u0001A\u0003%\u0001$\u0001\u0003dib\u0004\u0003bB\u0010\u0001\u0005\u0004%\t\u0001I\u0001\u0002aV\t\u0011\u0005\u0005\u0002#K9\u0011\u0011dI\u0005\u0003I\u0011\tq\u0001]1dW\u0006<W-\u0003\u0002'O\tY\u0011J\\8y!J|wM]1n\u0015\t!C\u0001\u0003\u0004*\u0001\u0001\u0006I!I\u0001\u0003a\u0002Bqa\u000b\u0001C\u0002\u0013\u0005A&A\u0006t_24XM\u001d(b[\u0016\u001cX#A\u0017\u0011\u00079:$H\u0004\u00020k9\u0011\u0001gM\u0007\u0002c)\u0011!GB\u0001\u0007yI|w\u000e\u001e \n\u0003Q\nQa]2bY\u0006L!\u0001\n\u001c\u000b\u0003QJ!\u0001O\u001d\u0003\u0007M+\u0017O\u0003\u0002%mA\u00111h\u0010\b\u0003yu\u0002\"\u0001\r\u001c\n\u0005y2\u0014A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u001c\t\r\r\u0003\u0001\u0015!\u0003.\u00031\u0019x\u000e\u001c<fe:\u000bW.Z:!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bQ\u0001^=qKN,\u0012a\u0012\t\u0004\u0011.cU\"A%\u000b\u0005)3\u0014AC2pY2,7\r^5p]&\u0011\u0001(\u0013\n\u0004\u001b>cf\u0001\u0002(\u0001\u00011\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"\u0001\u0015,\u000f\u0005E#fB\u0001*$\u001d\t\u00014+C\u0001\u0006\u0013\t)v%A\u0003ue\u0016,7/\u0003\u0002X1\n!A+\u001f9f\u0013\tI&LA\u0003UsB,7O\u0003\u0002\\\t\u0005\u0019\u0011m\u001d;\u0011\u0005usV\"\u0001\u001c\n\u0005}3$a\u0002)s_\u0012,8\r\u001e\u0005\u0007C\u0002\u0001\u000b\u0011B$\u0002\rQL\b/Z:!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\f!A^:\u0016\u0003\u0015\u00042\u0001S&g!\t\u0001v-\u0003\u0002iS\nAa+\u0019:jC\ndW-\u0003\u0002k5\nYQ\t\u001f9sKN\u001c\u0018n\u001c8t\u0011\u0019a\u0007\u0001)A\u0005K\u0006\u0019ao\u001d\u0011\t\u000f9\u0004!\u0019!C\u0001_\u000611M\\:ueN,\u0012\u0001\u001d\t\u0004\u0011.\u000b\bC\u0001)s\u0013\t\u0019\u0018N\u0001\u0003FqB\u0014\bBB;\u0001A\u0003%\u0001/A\u0004d]N$(o\u001d\u0011\t\u000b]\u0004A\u0011\u0001=\u0002\u0017\rDWmY6T_24XM\u001d\u000b\u0007sr\f\t\"!\u0007\u0011\u0005uS\u0018BA>7\u0005\u0011)f.\u001b;\t\u000bu4\b\u0019\u0001@\u0002\u0005M4'cA@\u0002\u0002\u0019!a\n\u0001\u0001\u007f!\r!\u00121A\u0005\u0004\u0003\u000b\u0011!!D*pYZ,'OR1di>\u0014\u0018\u0010C\u0005\u0002\n}\u0014\rQ\"\u0011\u0002\f\u00059\u0001O]8he\u0006lWCAA\u0007\u001d\r\tyAH\u0007\u0002\u0001!11M\u001ea\u0001\u0003'\u0001BaOA\u000bM&\u0019\u0011qC!\u0003\u0007M+G\u000f\u0003\u0004\u0002\u001cY\u0004\r!]\u0001\u0006G:\u001cHO\u001d")
public class SolversSuite
extends FunSuite {
    private final Context ctx = TestContext$.MODULE$.empty();
    private final Program p = package.InoxProgram$.MODULE$.apply(this.ctx(), (package.trees.Symbols)package.trees$.MODULE$.NoSymbols());
    private final Seq<String> solverNames = (Seq)((TraversableLike)((TraversableLike)(SolverFactory$.MODULE$.hasNativeZ3() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nativez3"})) : Nil$.MODULE$)).$plus$plus((GenTraversableOnce)(SolverFactory$.MODULE$.hasZ3() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smt-z3"})) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(SolverFactory$.MODULE$.hasCVC4() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smt-cvc4"})) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    private final Seq<Types.Type> types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.Type[]{package.trees$.MODULE$.BooleanType(), package.trees$.MODULE$.UnitType(), package.trees$.MODULE$.CharType(), package.trees$.MODULE$.RealType(), package.trees$.MODULE$.IntegerType(), package.trees$.MODULE$.Int32Type(), package.trees$.MODULE$.StringType(), package.trees$.MODULE$.TypeParameter().fresh("T"), new Types.SetType((Trees)package.trees$.MODULE$, (Types.Type)package.trees$.MODULE$.IntegerType()), new Types.BagType((Trees)package.trees$.MODULE$, (Types.Type)package.trees$.MODULE$.IntegerType()), new Types.MapType((Trees)package.trees$.MODULE$, (Types.Type)package.trees$.MODULE$.IntegerType(), (Types.Type)package.trees$.MODULE$.IntegerType()), new Types.FunctionType((Trees)package.trees$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.IntegerType$[]{package.trees$.MODULE$.IntegerType()})), (Types.Type)package.trees$.MODULE$.IntegerType()), new Types.TupleType((Trees)package.trees$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.Type[]{package.trees$.MODULE$.IntegerType(), package.trees$.MODULE$.BooleanType(), package.trees$.MODULE$.Int32Type()})))}));
    private final Seq<Expressions.Variable> vs = (Seq)this.types().map((Function1 & Serializable & scala.Serializable)tpe -> package.trees$.MODULE$.Variable().fresh("v", tpe, true), Seq$.MODULE$.canBuildFrom());
    private final Seq<Expressions.Expr> cnstrs = (Seq)this.vs().map((Function1 & Serializable & scala.Serializable)v -> {
        Expressions.Equals equals;
        Types.Type type = v.getType(this.p().symbols().implicitSymbols());
        if (package.trees$.MODULE$.UnitType().equals(type)) {
            equals = new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(v.getType(this.p().symbols().implicitSymbols())));
        } else if (type instanceof Types.SetType) {
            Types.SetType setType = (Types.SetType)type;
            Types.Type base = setType.base();
            equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.ElementOfSet((Trees)package.trees$.MODULE$, this.p().symbols().simplestValue(base), (Expressions.Expr)v));
        } else if (type instanceof Types.BagType) {
            Types.BagType bagType = (Types.BagType)type;
            Types.Type base = bagType.base();
            equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.MultiplicityInBag((Trees)package.trees$.MODULE$, this.p().symbols().simplestValue(base), (Expressions.Expr)v), this.p().symbols().simplestValue((Types.Type)package.trees$.MODULE$.IntegerType())));
        } else if (type instanceof Types.MapType) {
            Types.MapType mapType = (Types.MapType)type;
            Types.Type from = mapType.from();
            Types.Type to = mapType.to();
            equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.MapApply((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(from)), this.p().symbols().simplestValue(to)));
        } else if (type instanceof Types.FunctionType) {
            Types.FunctionType functionType = (Types.FunctionType)type;
            Seq froms = functionType.from();
            Types.Type to = functionType.to();
            equals = new Expressions.Not((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)new Expressions.Application((Trees)package.trees$.MODULE$, (Expressions.Expr)v, (Seq)froms.map((Function1 & Serializable & scala.Serializable)tpe -> this.p().symbols().simplestValue(tpe), Seq$.MODULE$.canBuildFrom())), this.p().symbols().simplestValue(to)));
        } else {
            equals = package.trees$.MODULE$.not((Expressions.Expr)new Expressions.Equals((Trees)package.trees$.MODULE$, (Expressions.Expr)v, this.p().symbols().simplestValue(v.getType(this.p().symbols().implicitSymbols()))));
        }
        return equals;
    }, Seq$.MODULE$.canBuildFrom());

    public Context ctx() {
        return this.ctx;
    }

    public Program p() {
        return this.p;
    }

    public Seq<String> solverNames() {
        return this.solverNames;
    }

    public Seq<Types.Type> types() {
        return this.types;
    }

    public Seq<Expressions.Variable> vs() {
        return this.vs;
    }

    public Seq<Expressions.Expr> cnstrs() {
        return this.cnstrs;
    }

    public void checkSolver(SolverFactory sf, Set<Expressions.Variable> vs, Expressions.Expr cnstr) {
        SolverResponses.ResponseWithModel responseWithModel = SimpleSolverAPI$.MODULE$.apply(sf).solveSAT(cnstr);
        if (!(responseWithModel instanceof SolverResponses.SatWithModel)) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Solver ", " - Constraint ", " is unsat!?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf.name(), cnstr.asString(this.p().printerOpts())})), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }
        SolverResponses.SatWithModel satWithModel = (SolverResponses.SatWithModel)responseWithModel;
        Map model = (Map)satWithModel.model();
        vs.foreach((Function1 & Serializable & scala.Serializable)v -> {
            Option option = model.get((Object)v.toVal());
            if (!(option instanceof Some)) {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Solver ", " - Model does not contain ", " of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf.name(), v.id().uniqueName(), v.tpe()})), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            }
            Some some = (Some)option;
            Expressions.Expr e = (Expressions.Expr)some.value();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getType(this.p().symbols().implicitSymbols()));
            Types.Type $org_scalatest_assert_macro_right = v.tpe();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Solver ", " - Extracting value of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf.name(), v.tpe()})), Prettifier$.MODULE$.default(), new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            return assertion;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SolversSuite() {
        this.solverNames().foreach((Function1 & Serializable & scala.Serializable)sname -> {
            this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model Extraction in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sname})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SolverFactory sf = SolverFactory$.MODULE$.apply(sname, $this.p(), $this.ctx().options());
                $this.checkSolver(sf, (Set<Expressions.Variable>)$this.vs().toSet(), package.trees$.MODULE$.andJoin($this.cnstrs()));
            }, new Position("SolversSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            return BoxedUnit.UNIT;
        });
    }
}

