/*
 * Decompiled with CFR 0.152.
 */
package ch.eitchnet.beaglebone;

import ch.eitchnet.beaglebone.Direction;
import ch.eitchnet.beaglebone.Gpio;
import ch.eitchnet.beaglebone.GpioBridge;
import ch.eitchnet.beaglebone.GpioBridgeTest;
import ch.eitchnet.beaglebone.GpioException;
import ch.eitchnet.beaglebone.GpioSignalListener;
import ch.eitchnet.beaglebone.Pin;
import ch.eitchnet.beaglebone.Signal;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GpioBridgeImpl
implements GpioBridge {
    private static final String GPIO_PATH = "/sys/class/gpio/";
    private Map<Pin, Gpio> cache = new HashMap<Pin, Gpio>();
    private Map<Gpio, List<GpioSignalListener>> listeners = Collections.synchronizedMap(new HashMap());
    private Thread thread;
    private volatile boolean run;
    private static final GpioBridge instance = new GpioBridgeImpl();

    public static GpioBridge getInstance() {
        return instance;
    }

    private GpioBridgeImpl() {
    }

    private File getGpioValuePath(Gpio gpio) {
        return new File(GPIO_PATH, gpio.getKernelName() + "/value");
    }

    private File getGpioDirectionPath(Gpio gpio) {
        return new File(GPIO_PATH, gpio.getKernelName() + "/direction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(Gpio gpio, Signal signal) throws GpioException {
        Gpio gpio2 = gpio;
        synchronized (gpio2) {
            if (gpio.getDirection() != Direction.OUT) {
                throw new GpioException("For writing the direction must be " + (Object)((Object)Direction.OUT));
            }
            File file = this.getGpioValuePath(gpio);
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(signal.getValueS().getBytes());
                out.flush();
                gpio.setSignal(signal);
            }
            catch (Exception e) {
                throw new GpioException("Failed to write GPIO " + gpio + " with signal " + (Object)((Object)signal), e);
            }
            System.out.println("Set GPIO " + (Object)((Object)gpio.getPin()) + " signal to " + (Object)((Object)gpio.getSignal()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Signal readValue(Gpio gpio) throws GpioException {
        Gpio gpio2 = gpio;
        synchronized (gpio2) {
            if (gpio.getDirection() != Direction.IN) {
                throw new GpioException("For reading the direction must be " + (Object)((Object)Direction.IN));
            }
            File file = this.getGpioValuePath(gpio);
            try (BufferedReader fin = new BufferedReader(new FileReader(file));){
                String valueS = fin.readLine();
                Signal signal = Signal.getSignal(valueS);
                if (!gpio.getSignal().equals((Object)signal)) {
                    gpio.setSignal(signal);
                }
                Signal signal2 = signal;
                return signal2;
            }
            catch (Exception e) {
                throw new GpioException("Failed to read GPIO " + gpio, e);
            }
        }
    }

    @Override
    public void start() {
        this.run = true;
        this.thread = new Thread(() -> {
            while (this.run) {
                if (this.listeners.isEmpty()) {
                    GpioBridgeImpl gpioBridgeImpl = this;
                    synchronized (gpioBridgeImpl) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            System.out.println("Was interrupted. Stopping thread.");
                            this.run = false;
                            break;
                        }
                    }
                }
                ArrayList<Gpio> changes = new ArrayList<Gpio>();
                Map<Gpio, List<GpioSignalListener>> e = this.listeners;
                synchronized (e) {
                    for (Gpio gpio : this.listeners.keySet()) {
                        try {
                            Gpio gpio2 = gpio;
                            synchronized (gpio2) {
                                Signal currentSignal = gpio.getSignal();
                                Signal newSignal = this.readValue(gpio);
                                if (currentSignal != newSignal) {
                                    changes.add(gpio);
                                }
                            }
                        }
                        catch (Exception e2) {
                            System.out.println("Failed to read GPIO " + gpio + " due to:");
                            e2.printStackTrace();
                            this.run = false;
                            break;
                        }
                    }
                }
                if (!changes.isEmpty()) {
                    System.out.println("Found " + changes.size() + " GPIO changes.");
                }
                for (Gpio gpio : changes) {
                    Map<Gpio, List<GpioSignalListener>> map = this.listeners;
                    synchronized (map) {
                        List<GpioSignalListener> listeners = this.listeners.get(gpio);
                        System.out.println("GPIO " + (Object)((Object)gpio.getPin()) + " changed to " + (Object)((Object)gpio.getSignal()) + ". Notifying " + listeners.size() + " listeners.");
                        for (GpioSignalListener listener : listeners) {
                            try {
                                listener.notify(gpio);
                            }
                            catch (Exception e3) {
                                System.out.println("Failed to update listener " + listener + " due to:");
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e2) {
                    System.out.println("Was interrupted. Stopping thread.");
                    this.run = false;
                    break;
                }
            }
        }, "gpio_reader");
        this.thread.start();
        System.out.println("Started GPIO bridge.");
    }

    @Override
    public void stop() {
        this.run = false;
        this.thread.interrupt();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("Was interrupted while waiting for thread to stop?!");
        }
    }

    @Override
    public synchronized Gpio getGpio(Pin pin, Direction direction) throws GpioException {
        Gpio gpio = this.cache.get((Object)pin);
        if (gpio == null) {
            gpio = new Gpio(pin, direction);
            this.assertDirection(gpio);
            this.validateFilePermissions(gpio);
            this.cache.put(pin, gpio);
            System.out.println("Initialized pin " + (Object)((Object)pin) + " with direction " + (Object)((Object)direction) + ".");
        }
        return gpio;
    }

    private void assertDirection(Gpio gpio) throws GpioException {
        File file = this.getGpioDirectionPath(gpio);
        Pin pin = gpio.getPin();
        try (BufferedReader fin = new BufferedReader(new FileReader(file));){
            String directionS = fin.readLine();
            Direction dir = Direction.getDirection(directionS);
            if (dir != gpio.getDirection()) {
                throw new GpioException("Actual direction of GPIO " + (Object)((Object)pin) + " is " + (Object)((Object)dir) + " not " + directionS);
            }
        }
        catch (FileNotFoundException e) {
            throw new GpioException("GPIO " + (Object)((Object)pin) + " does not exist, was the pin exported to user space?", e);
        }
        catch (IOException e) {
            throw new GpioException("Failed to open GPIO " + (Object)((Object)pin), e);
        }
    }

    private void validateFilePermissions(Gpio gpio) throws GpioException {
        File gpioValuePath = this.getGpioValuePath(gpio);
        Direction direction = gpio.getDirection();
        if (direction == Direction.IN) {
            if (!gpioValuePath.canRead()) {
                throw new GpioException("GPIO " + gpio + " has direction " + (Object)((Object)direction) + " and is not readable. Are the file permissions ok?");
            }
        } else if (direction == Direction.OUT) {
            if (!gpioValuePath.canWrite()) {
                throw new GpioException("GPIO " + gpio + " has direction " + (Object)((Object)direction) + " and is not writable. Are the file permissions ok?");
            }
        } else {
            throw new RuntimeException("Unhandled Direction " + (Object)((Object)direction));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Gpio gpio, GpioSignalListener listener) throws GpioException {
        if (gpio.getDirection() != Direction.IN) {
            throw new GpioException("For reading the direction must be " + (Object)((Object)Direction.IN));
        }
        Object object = this.listeners;
        synchronized (object) {
            List<GpioSignalListener> listeners = this.listeners.get(gpio);
            if (listeners == null) {
                listeners = new ArrayList<GpioSignalListener>();
                this.listeners.put(gpio, listeners);
            }
            listeners.add(listener);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(GpioBridgeTest gpio, GpioSignalListener listener) {
        Map<Gpio, List<GpioSignalListener>> map = this.listeners;
        synchronized (map) {
            List<GpioSignalListener> listeners = this.listeners.get(gpio);
            if (listeners == null) {
                return false;
            }
            boolean removed = listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(gpio);
            }
            return removed;
        }
    }
}

