package ch.vd.shared.iam.web.filter.session;

import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Invalide la HttpSession a la fin de la HttpRequest
 * Utile en Web-Service REST pour pas conserver une Session inutilement
 *
 * @author jec
 */
public class HttpSessionInvalidatorSpringFilter extends GenericFilterBean {

    private boolean clearSecurityContext = true;
    private boolean invalidateSession = true;

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;

        chain.doFilter(request, response);

        if (invalidateSession) {
            if (request.getSession(false) != null) {
                request.getSession().invalidate();
            }
        }

        if (clearSecurityContext) {
            SecurityContextHolder.clearContext();
        }
    }

    public void setClearSecurityContext(boolean clearSecurityContext) {
        this.clearSecurityContext = clearSecurityContext;
    }

    public void setInvalidateSession(boolean invalidateSession) {
        this.invalidateSession = invalidateSession;
    }
}
