package ch.vd.shared.iam.web.filter.logout;

import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.util.UrlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Plus de détails : voir https://portail.etat-de-vaud.ch/outils/dsiwiki/display/PlateformeIAM/IAM-AM
 *
 * Redirect straegy qui renvoie du HTML au browser pour que le client fasse la redirection
 *
 * @author dgo
 */
public class RealHtmlLogoutRedirectStrategy extends DefaultRedirectStrategy {

    @Override
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {

        String redirectUrl = calculateRedirectUrl(request.getContextPath(), url);
        redirectUrl = response.encodeRedirectURL(redirectUrl);

        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append("    <script type=\"text/javascript\">");
        html.append("        document.location.href=\"" + redirectUrl + "\";");
        html.append("    </script>");
        html.append("</html>");

        response.getOutputStream().write(html.toString().getBytes());
    }

    @Override
    protected String calculateRedirectUrl(String contextPath, String url) {
        if (!UrlUtils.isAbsoluteUrl(url)) {
            return contextPath + url;
        }

        // Full URL, including http(s)://
        return url;
    }
}
