package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.web.common.IamConstants;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;

public class IamRequestWrapper {

    public static final String X_FORWARDED_HOST = "x-forwarded-host";
    public static final String HOST_TO_MATCH = "prestations.vd.ch";
    private final HttpServletRequest request;
    private Boolean isOriginACV = true;

    public IamRequestWrapper(HttpServletRequest request) {
        Objects.requireNonNull(request, "request cannot be null");
        this.request = request;

        isRequestFromACV(request);
    }

    private void isRequestFromACV(HttpServletRequest request) {
        String xForwardedForHeader = request.getHeader(X_FORWARDED_HOST);
        isOriginACV = (null == xForwardedForHeader || !xForwardedForHeader.contains(HOST_TO_MATCH));
    }

    public Boolean getOriginACV() {
        return isOriginACV;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public Map getParameterMap() {
        return request.getParameterMap();
    }

    public String getParameter(String p) {
        return request.getParameter(p);
    }

    public HttpSession getSession() {
        return request.getSession();
    }

    public String getHeader(String header) {
        return request.getHeader(header);
    }

    public String getMethod() {
        return request.getMethod();
    }

    public String getRequestURI() {
        return request.getRequestURI();
    }

    public String getContextPath() {
        return request.getContextPath();
    }

    public String getApplication() {
        return request.getHeader(IamConstants.IAM_HEADER_APPLICATION);
    }

    public String getUserName() {
        return request.getHeader(IamConstants.IAM_HEADER_USERNAME);
    }

    public String getRoles() {
        return request.getHeader(IamConstants.IAM_HEADER_ROLES);
    }

    public Integer getAuthLevel() {
        String authLevelStr = request.getHeader(IamConstants.IAM_HEADER_AUTHLEVEL);
        if (StringUtils.isNotBlank(authLevelStr)) {
            return Integer.parseInt(authLevelStr);
        }
        return null;
    }

    public String getLastLogin() {
        return request.getHeader(IamConstants.IAM_HEADER_LASTLOGIN);
    }

    public String getFirstName() {
        String headerValue = request.getHeader(IamConstants.IAM_HEADER_FIRSTNAME);
        return isOriginACV ? isoToUtf8(headerValue) : headerValue;
    }

    public String getLastName() {
        String headerValue = request.getHeader(IamConstants.IAM_HEADER_LASTNAME);
        return isOriginACV ? isoToUtf8(headerValue) : headerValue;
    }

    public String getEmail() {
        return request.getHeader(IamConstants.IAM_HEADER_EMAIL);
    }

    /**
     * Converts an input string from ISO8859-1 to UTF-8
     */
    public static String isoToUtf8(String isoIn) {
        if (isoIn != null) {
            try {
                return new String(isoIn.getBytes("ISO8859-1"), "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                // should never occur
                throw new RuntimeException(ex);
            }
        }

        return null;
    }
}
