package ch.vd.shared.iam.utils;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ApplicationVersion {

    private static String version = null;
    private static String buildDate = null;

    private static Map<String, String> buildDateArray = null;

    /**
     * Renvoie la version complète. Ex: 14L1.A.4-SNAPSHOT ou 13L4.B.2
     */
    public static String get() {
        if (version == null) {
            readLines();
            version = buildDateArray.get("version");
        }
        return version;
    }


    public static String getBuildDate() {
        if (buildDate == null) {
            readLines();
            buildDate = buildDateArray.get("buildDate");
        }
        return buildDate;
    }

    private static void readLines() {
        try (InputStream is = ApplicationVersion.class.getResourceAsStream("/version.txt")) {
            readLines(is);
        } catch (IOException ioe) {
            throw new RuntimeException("Impossible de récupérer la version de l'application", ioe);
        }
    }

    private static void readLines(InputStream is) throws IOException {
        if (buildDateArray == null) {
            Objects.requireNonNull(is, "Le fichier version.txt est introuvable");
            // On passe par un byte array pour pouvoir fermer le stream rapidement (le fichier est très petit)
            byte[] data = IOUtils.toByteArray(is);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));

            Map<String, String> list = new HashMap<>();
            String line = reader.readLine();
            while (line != null) {
                if (StringUtils.isNotBlank(line)) {
                    String[] parts = line.split("=");
                    if (parts.length > 1) {
                        list.put(parts[0], parts[1]);
                    } else {
                        list.put(parts[0], "");
                    }
                }
                line = reader.readLine();
            }
            buildDateArray = list;
        }
    }
}
