package ch.vd.shared.iam.model.application;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class UsersFavoriteApplicationsRepositoryImpl implements UsersFavoriteApplicationsCustomRepository {

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void addFavoriteAppForIup(String iup, Long applicationId) {
        IamApplication reference = entityManager.getReference(IamApplication.class, applicationId);
        UsersFavoriteApplications usersFavoriteApplications = new UsersFavoriteApplications();
        usersFavoriteApplications.setIamApplication(reference);
        usersFavoriteApplications.setIup(iup);
        entityManager.persist(usersFavoriteApplications);
    }

    @Override
    public void removeFavoriteForIup(String iup, Long applicationId) {
        IamApplication reference = entityManager.getReference(IamApplication.class, applicationId);
        entityManager.createQuery("DELETE FROM UsersFavoriteApplications WHERE iup = :iup AND iamApplication = :appId")
                .setParameter("iup", iup)
                .setParameter("appId", reference)
                .executeUpdate();
    }
}
