package ch.vd.shared.iam.model.application;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Getter
@Setter
@Entity
@Table(name = "users_favorite_applications", uniqueConstraints = @UniqueConstraint(columnNames = {"IUP", "APPLICATION_ID"}))
public class UsersFavoriteApplications {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "users_favorite_applications_id_seq")
    @Column(name = "ID")
    private Long id;

    @Column(name = "IUP", nullable = false)
    private String iup;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "APPLICATION_ID", nullable = false)
    private IamApplication iamApplication;
}
