package ch.vd.shared.iam.model.application;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@Entity
@Table(name = "IAM_APPLICATION")
public class IamApplication {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "iamapplication_sequence")
    @SequenceGenerator(name = "iamapplication_sequence", sequenceName = "iam_application_id_seq", allocationSize = 1)
    @Column(name = "ID")
    private Long id;

    @Column(name = "IS_VISIBLE")
    private Boolean isVisible = Boolean.FALSE;

    @Column(name = "NAME")
    private String name;

    @Column(name = "LABEL")
    private String label;

    @Column(name = "URL")
    private String url;

    @Column(name = "ACCESS_TYPE")
    private String accessType;

    @Column(name = "MESSAGE", length = 340)
    private String message;

    @Column(name = "DATE_DEB_MESSAGE")
    private ZonedDateTime dateDebMessage;

    @Column(name = "DATE_FIN_MESSAGE")
    private ZonedDateTime dateFinMessage;

    @Column(name = "DATE_DEB_INDISPO")
    private ZonedDateTime dateDebIndispo;

    @Column(name = "DATE_FIN_INDISPO")
    private ZonedDateTime dateFinIndispo;

    @Column(name = "DATE_MODIF")
    private ZonedDateTime dateModif = ZonedDateTime.now(ZoneOffset.UTC);

    @Column(name = "IUP_MODIF", length = 20)
    private String iupModif;

    @JsonIgnore
    @OneToMany(mappedBy = "iamApplication", cascade = CascadeType.REMOVE)
    private List<UsersFavoriteApplications> usersFavoriteApplications = new ArrayList<>();
}
