/*
 * Decompiled with CFR 0.152.
 */
package ch.docksnet.codegen;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DecoupledSpringMvcGenerator
extends JavaClientCodegen {
    public static final String CONFIG_PACKAGE = "configPackage";
    protected String title = "Petstore Server";
    protected String configPackage = "";
    protected String templateFileName = "api.mustache";

    public DecoupledSpringMvcGenerator() {
        this.outputFolder = "generated-code/decoupledSpringMvc";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put(this.templateFileName, ".java");
        this.templateDir = "decoupledSpringMvc";
        this.embeddedTemplateDir = "decoupledSpringMvc";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.configPackage = "io.swagger.configuration";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-spring-mvc-server";
        this.setModelNameSuffix("Dto");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
        this.supportedLibraries.clear();
        this.supportedLibraries.put("<default>", "Default Spring MVC server stub.");
        this.supportedLibraries.put("j8-async", "Use async servlet feature and Java 8's default interface. Generating interface with service declaration is useful when using Maven plugin. Just provide a implementation with @Controller to instantiate service.");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "decoupled-spring-mvc";
    }

    public String getHelp() {
        return "Generates a decoupledSpringMvc server library.";
    }

    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("type.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "Type.java"));
        this.supportingFiles.add(new SupportingFile("apiException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("apiOriginFilter.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("apiResponseMessage.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("notFoundException.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "NotFoundException.java"));
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                List responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        if ("j8-async".equals(this.getLibrary())) {
            this.apiTemplateFiles.remove(this.templateFileName);
            this.templateFileName = "api-j8-async.mustache";
            this.apiTemplateFiles.put(this.templateFileName, ".java");
            int originalPomFileIdx = -1;
            for (int i = 0; i < this.supportingFiles.size(); ++i) {
                if (!"pom.xml".equals(((SupportingFile)this.supportingFiles.get((int)i)).destinationFilename)) continue;
                originalPomFileIdx = i;
                break;
            }
            if (originalPomFileIdx > -1) {
                this.supportingFiles.remove(originalPomFileIdx);
            }
            this.supportingFiles.add(new SupportingFile("pom-j8-async.mustache", "", "pom.xml"));
        }
        return objs;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return DecoupledSpringMvcGenerator.camelize((String)name) + "Api";
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.endsWith(".Object")) continue;
            iterator.remove();
        }
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.isEnum || var.defaultValue == null || "null".equals(var.defaultValue)) continue;
                var.defaultValue = var.datatypeWithEnum + "." + var.defaultValue;
            }
        }
        return objs;
    }
}

