/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DIMethods {
    private final Class<?> type;

    public DIMethods(Class<?> type) {
        this.type = type;
    }

    public DIMethod mustContainExactlyOneMethod(String methodName) {
        List<Method> methods = this.getMethods(methodName);
        switch (methods.size()) {
            case 0: {
                throw new IllegalArgumentException(this.type + " does not contain a method '" + methodName + "'");
            }
            case 1: {
                return new DIMethod(methods.get(0));
            }
        }
        throw new IllegalArgumentException(this.type + " does contain multiple methods '" + methodName + "': " + methods);
    }

    public DIMethods mustHaveNumberOfMethods(int numberOfMethods) {
        if (this.type.getMethods().length != numberOfMethods) {
            throw new IllegalArgumentException(this.type + " must have EXACTLY " + numberOfMethods + " method(s)");
        }
        return this;
    }

    public DIMethods mustNotBeAnInterface() {
        if (!this.type.isInterface()) {
            throw new IllegalArgumentException(this.type + " must be an interface");
        }
        return this;
    }

    public boolean containsMethod(String methodName, Class<?> ... paramTypes) {
        List<Method> methods = this.getMethods(methodName);
        for (Method method : methods) {
            if (!new DIMethod(method).hasParametersOfType(paramTypes)) continue;
            return true;
        }
        return false;
    }

    private List<Method> getMethods(String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.type.getMethods()) {
            if (!method.getName().endsWith(methodName)) continue;
            methods.add(method);
        }
        return methods;
    }
}

