/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;

public class DIMethod {
    private final Method method;

    public DIMethod(Method method) {
        this.method = method;
    }

    public boolean hasParametersOfType(Class<?> ... givenParamTypesArray) {
        Class<?>[] methodParamTypesArray = this.method.getParameterTypes();
        if (givenParamTypesArray.length != methodParamTypesArray.length) {
            return false;
        }
        ArrayList givenParamTypes = new ArrayList();
        Collections.addAll(givenParamTypes, givenParamTypesArray);
        for (int i = 0; i < methodParamTypesArray.length; ++i) {
            Class<?> paramType = methodParamTypesArray[i];
            if (paramType.isAssignableFrom((Class)givenParamTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public DIMethod mustHaveParametersOfType(Class<?> ... givenParamTypesArray) {
        Class<?>[] methodParamTypesArray = this.method.getParameterTypes();
        if (givenParamTypesArray.length != methodParamTypesArray.length) {
            throw new IllegalArgumentException("Given param types (length=" + givenParamTypesArray.length + ") should have same length as method param types (length=" + methodParamTypesArray.length + ")");
        }
        ArrayList givenParamTypes = new ArrayList();
        Collections.addAll(givenParamTypes, givenParamTypesArray);
        for (int i = 0; i < methodParamTypesArray.length; ++i) {
            Class<?> paramType = methodParamTypesArray[i];
            if (paramType.isAssignableFrom((Class)givenParamTypes.get(i))) continue;
            throw new IllegalArgumentException("Method param type '" + paramType + "' is NOT assignable from given param type '" + givenParamTypes.get(i) + "'");
        }
        return this;
    }

    public DIMethod mustHaveReturnType(Class<?> givenReturnType) {
        if (!givenReturnType.isAssignableFrom(this.method.getReturnType())) {
            throw new IllegalArgumentException("Given Return type '" + givenReturnType + "' is NOT assignable from method return type '" + this.method.getReturnType() + "'");
        }
        return this;
    }
}

