/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;

public class DIConstructorParam {
    private final String name;
    private final Class<?> type;
    private final List<Annotation> annotations;

    public DIConstructorParam(String name, Class<?> type, List<Annotation> annotations) {
        this.name = name;
        this.type = type;
        this.annotations = annotations;
    }

    public String toString() {
        return "ConstructorParam{name='" + this.name + '\'' + ", type=" + this.type + ", annotations=" + this.annotations + '}';
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isArrayOfPrimitives() {
        this.mustBeAnArray();
        return this.type.getComponentType().isPrimitive();
    }

    public boolean isArrayOfArrays() {
        this.mustBeAnArray();
        return this.type.getComponentType().isArray();
    }

    public boolean isArrayOfEnums() {
        this.mustBeAnArray();
        return this.type.getComponentType().isEnum();
    }

    public boolean isArrayOfStrings() {
        this.mustBeAnArray();
        return String.class.isAssignableFrom(this.type.getComponentType());
    }

    public boolean isArrayOfNumbers() {
        this.mustBeAnArray();
        return Number.class.isAssignableFrom(this.type.getComponentType());
    }

    public boolean isArrayOfDates() {
        this.mustBeAnArray();
        return Date.class.isAssignableFrom(this.type.getComponentType());
    }

    public boolean isNumber() {
        this.mustNotBeAnArray();
        return Number.class.isAssignableFrom(this.type);
    }

    public boolean isPrimitive() {
        this.mustNotBeAnArray();
        return this.type.isPrimitive();
    }

    public boolean isEnum() {
        this.mustNotBeAnArray();
        return this.type.isEnum();
    }

    public boolean isString() {
        this.mustNotBeAnArray();
        return String.class.isAssignableFrom(this.type);
    }

    public boolean isDate() {
        this.mustNotBeAnArray();
        return Date.class.isAssignableFrom(this.type);
    }

    public boolean isCharacter() {
        this.mustNotBeAnArray();
        return Character.class.isAssignableFrom(this.type);
    }

    public boolean isBoolean() {
        this.mustNotBeAnArray();
        return Boolean.class.isAssignableFrom(this.type);
    }

    private void mustBeAnArray() {
        if (!this.type.isArray()) {
            throw new IllegalStateException(this.type + " is not an array");
        }
    }

    private void mustNotBeAnArray() {
        if (this.type.isArray()) {
            throw new IllegalStateException(this.type + " is an array");
        }
    }
}

