/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DIConstructor {
    private final Constructor<?> constructor;
    private final Paranamer paranamer = new AdaptiveParanamer();
    private final Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap;

    public DIConstructor(Constructor<?> constructor, Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap) {
        this.constructor = constructor;
        this.wrappedPrimitiveTypeMap = wrappedPrimitiveTypeMap;
    }

    public String getName() {
        return this.constructor.getDeclaringClass().getName();
    }

    public boolean matchesParams(Object ... givenParams) {
        ArrayList givenParamTypes = new ArrayList();
        for (Object givenParam : givenParams) {
            if (givenParam == null) {
                throw new IllegalArgumentException("Given param must NOT be null");
            }
            givenParamTypes.add(givenParam.getClass());
        }
        return this.matchesParamTypes(givenParamTypes.toArray(new Class[givenParamTypes.size()]));
    }

    public boolean matchesParamTypes(Class<?> ... givenParamTypes) {
        Class<?>[] constructorParamTypesArray = this.constructor.getParameterTypes();
        if (givenParamTypes.length != constructorParamTypesArray.length) {
            return false;
        }
        for (int i = 0; i < constructorParamTypesArray.length; ++i) {
            Class<?> wrappedParamType;
            Class<?> paramType = constructorParamTypesArray[i];
            if (paramType.isPrimitive()) {
                wrappedParamType = this.wrappedPrimitiveTypeMap.get(paramType);
                if (wrappedParamType == null) {
                    throw new IllegalStateException("there is no wrapped type available for primitive type '" + paramType + '\"');
                }
            } else {
                wrappedParamType = paramType;
            }
            if (wrappedParamType.isAssignableFrom(givenParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    public <T> T newInstance(List<Object> initArgsAsList) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.newInstance(initArgsAsList.toArray());
    }

    public <T> T newInstance(Object ... initArgs) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return (T)this.constructor.newInstance(initArgs);
    }

    public List<String> getParameterNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        Collections.addAll(paramNames, this.paranamer.lookupParameterNames(this.constructor));
        return paramNames;
    }

    public Class<?> getParamType(int paramIndex) {
        this.checkParamIndex(paramIndex);
        return this.constructor.getParameterTypes()[paramIndex];
    }

    public List<Annotation> getParamAnnotations(int paramIndex) {
        this.checkParamIndex(paramIndex);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Collections.addAll(annotations, this.constructor.getParameterAnnotations()[paramIndex]);
        return annotations;
    }

    private void checkParamIndex(int paramIndex) {
        if (paramIndex < 0) {
            throw new IllegalArgumentException(this.constructor + ": Param index must be 0 or greater, but is " + paramIndex);
        }
        if (paramIndex >= this.constructor.getParameterTypes().length) {
            throw new IndexOutOfBoundsException(this.constructor + ": Invalid parameter index " + paramIndex + " - constructor only " + this.constructor.getParameterTypes().length + " parameters");
        }
    }
}

